/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.apache.logging.log4j.core.pattern.HighlightConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class HighlightConverterTest {
    @Test
    public void testAnsiEmpty() {
        String[] options = new String[]{"", "noConsoleNoAnsi=false, disableAnsi=false"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName("a.b.c").setMessage((Message)new SimpleMessage("message in a bottle")).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assert.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    public void testAnsiNonEmpty() {
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName("a.b.c").setMessage((Message)new SimpleMessage("message in a bottle")).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assert.assertEquals((Object)"\u001b[32mINFO : message in a bottle\u001b[m", (Object)buffer.toString());
    }

    @Test
    public void testLevelNamesBad() {
        String colorName = "red";
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false, BAD_LEVEL_A=" + colorName + ", BAD_LEVEL_B=" + colorName};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assert.assertNotNull((Object)converter);
        Assert.assertNotNull((Object)converter.getLevelStyle(Level.TRACE));
        Assert.assertNotNull((Object)converter.getLevelStyle(Level.DEBUG));
    }

    @Test
    public void testLevelNamesGood() {
        String colorName = "red";
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false, DEBUG=" + colorName + ", TRACE=" + colorName};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assert.assertNotNull((Object)converter);
        Assert.assertEquals((Object)AnsiEscape.createSequence((String[])new String[]{colorName}), (Object)converter.getLevelStyle(Level.TRACE));
        Assert.assertEquals((Object)AnsiEscape.createSequence((String[])new String[]{colorName}), (Object)converter.getLevelStyle(Level.DEBUG));
    }

    @Test
    public void testLevelNamesNone() {
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assert.assertNotNull((Object)converter);
        Assert.assertNotNull((Object)converter.getLevelStyle(Level.TRACE));
        Assert.assertNotNull((Object)converter.getLevelStyle(Level.DEBUG));
    }

    @Test
    public void testNoAnsiEmpty() {
        String[] options = new String[]{"", "disableAnsi=true"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName("a.b.c").setMessage((Message)new SimpleMessage("message in a bottle")).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assert.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    public void testNoAnsiNonEmpty() {
        String[] options = new String[]{"%-5level: %msg", "disableAnsi=true"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName("a.b.c").setMessage((Message)new SimpleMessage("message in a bottle")).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assert.assertEquals((Object)"INFO : message in a bottle", (Object)buffer.toString());
    }
}

