/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import org.apache.logging.log4j.core.AbstractLogEvent;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.pattern.DatePatternConverter;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DatePatternConverterTest {
    private static final String DEFAULT_PATTERN = FixedDateFormat.FixedFormat.DEFAULT.getPattern();
    private static final String ISO8601_FORMAT = FixedDateFormat.FixedFormat.ISO8601.name();
    private static final String[] ISO8601_FORMAT_OPTIONS = new String[]{ISO8601_FORMAT};

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({Boolean.TRUE}, {Boolean.FALSE});
    }

    public DatePatternConverterTest(Boolean threadLocalEnabled) throws Exception {
        Field field = Constants.class.getDeclaredField("ENABLE_THREADLOCALS");
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.setBoolean(null, threadLocalEnabled);
    }

    @Test
    public void testNewInstanceAllowsNullParameter() {
        DatePatternConverter.newInstance(null);
    }

    @Test
    public void testFormatLogEventStringBuilderDefaultPattern() {
        MyLogEvent event = new MyLogEvent();
        DatePatternConverter converter = DatePatternConverter.newInstance(null);
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String expected = "2011-12-30 10:56:35,987";
        Assert.assertEquals((Object)"2011-12-30 10:56:35,987", (Object)sb.toString());
    }

    @Test
    public void testFormatLogEventStringBuilderIso8601() {
        MyLogEvent event = new MyLogEvent();
        DatePatternConverter converter = DatePatternConverter.newInstance((String[])ISO8601_FORMAT_OPTIONS);
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String expected = "2011-12-30T10:56:35,987";
        Assert.assertEquals((Object)"2011-12-30T10:56:35,987", (Object)sb.toString());
    }

    @Test
    public void testFormatLogEventStringBuilderIso8601TimezoneUTC() {
        MyLogEvent event = new MyLogEvent();
        DatePatternConverter converter = DatePatternConverter.newInstance((String[])new String[]{"ISO8601", "UTC"});
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat sdf = new SimpleDateFormat(converter.getPattern());
        sdf.setTimeZone(tz);
        long adjusted = event.getTimeMillis() + (long)tz.getDSTSavings();
        String expected = sdf.format(new Date(adjusted));
        Assert.assertEquals((Object)expected, (Object)sb.toString());
    }

    @Test
    public void testFormatLogEventStringBuilderIso8601TimezoneJST() {
        MyLogEvent event = new MyLogEvent();
        String[] optionsWithTimezone = new String[]{ISO8601_FORMAT, "JST"};
        DatePatternConverter converter = DatePatternConverter.newInstance((String[])optionsWithTimezone);
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        TimeZone tz = TimeZone.getTimeZone("JST");
        SimpleDateFormat sdf = new SimpleDateFormat(converter.getPattern());
        sdf.setTimeZone(tz);
        long adjusted = event.getTimeMillis() + (long)tz.getDSTSavings();
        String expected = sdf.format(new Date(adjusted));
        Assert.assertEquals((Object)expected, (Object)sb.toString());
    }

    @Test
    public void testPredefinedFormatWithTimezone() {
        for (FixedDateFormat.FixedFormat format : FixedDateFormat.FixedFormat.values()) {
            String[] options = new String[]{format.name(), "PDT"};
            DatePatternConverter converter = DatePatternConverter.newInstance((String[])options);
            Assert.assertEquals((Object)format.getPattern(), (Object)converter.getPattern());
        }
    }

    @Test
    public void testPredefinedFormatWithoutTimezone() {
        for (FixedDateFormat.FixedFormat format : FixedDateFormat.FixedFormat.values()) {
            String[] options = new String[]{format.name()};
            DatePatternConverter converter = DatePatternConverter.newInstance((String[])options);
            Assert.assertEquals((Object)format.getPattern(), (Object)converter.getPattern());
        }
    }

    private String precisePattern(String pattern, int precision) {
        String seconds = pattern.substring(0, pattern.indexOf("SSS"));
        return seconds + "nnnnnnnnn".substring(0, precision);
    }

    @Test
    public void testPredefinedFormatWithAnyValidNanoPrecision() {
        StringBuilder precise = new StringBuilder();
        StringBuilder milli = new StringBuilder();
        MyLogEvent event = new MyLogEvent();
        for (String timeZone : new String[]{"PDT", null}) {
            for (FixedDateFormat.FixedFormat format : FixedDateFormat.FixedFormat.values()) {
                for (int i = 1; i <= 9; ++i) {
                    if (format.getPattern().endsWith("n")) continue;
                    precise.setLength(0);
                    milli.setLength(0);
                    String[] preciseOptions = new String[]{this.precisePattern(format.getPattern(), i), timeZone};
                    DatePatternConverter preciseConverter = DatePatternConverter.newInstance((String[])preciseOptions);
                    preciseConverter.format((LogEvent)event, precise);
                    String[] milliOptions = new String[]{format.getPattern(), timeZone};
                    DatePatternConverter.newInstance((String[])milliOptions).format((LogEvent)event, milli);
                    milli.setLength(milli.length() - 3);
                    String expected = milli.append("987123456".substring(0, i)).toString();
                    Assert.assertEquals((Object)expected, (Object)precise.toString());
                }
            }
        }
    }

    @Test
    public void testInvalidLongPatternIgnoresExcessiveDigits() {
        StringBuilder precise = new StringBuilder();
        StringBuilder milli = new StringBuilder();
        MyLogEvent event = new MyLogEvent();
        for (FixedDateFormat.FixedFormat format : FixedDateFormat.FixedFormat.values()) {
            if (format.getPattern().endsWith("n")) continue;
            precise.setLength(0);
            milli.setLength(0);
            String pattern = format.getPattern().substring(0, format.getPattern().indexOf("SSS"));
            String[] preciseOptions = new String[]{pattern + "nnnnnnnnn" + "n"};
            DatePatternConverter preciseConverter = DatePatternConverter.newInstance((String[])preciseOptions);
            preciseConverter.format((LogEvent)event, precise);
            String[] milliOptions = new String[]{format.getPattern()};
            DatePatternConverter.newInstance((String[])milliOptions).format((LogEvent)event, milli);
            milli.setLength(milli.length() - 3);
            String expected = milli.append("987123456").toString();
            Assert.assertEquals((Object)expected, (Object)precise.toString());
        }
    }

    @Test
    public void testFormatObjectStringBuilderDefaultPattern() {
        DatePatternConverter converter = DatePatternConverter.newInstance(null);
        StringBuilder sb = new StringBuilder();
        converter.format((Object)"nondate", sb);
        String expected = "";
        Assert.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testFormatDateStringBuilderDefaultPattern() {
        DatePatternConverter converter = DatePatternConverter.newInstance(null);
        StringBuilder sb = new StringBuilder();
        converter.format(this.date(2001, 1, 1), sb);
        String expected = "2001-02-01 14:15:16,123";
        Assert.assertEquals((Object)"2001-02-01 14:15:16,123", (Object)sb.toString());
    }

    @Test
    public void testFormatDateStringBuilderIso8601() {
        DatePatternConverter converter = DatePatternConverter.newInstance((String[])ISO8601_FORMAT_OPTIONS);
        StringBuilder sb = new StringBuilder();
        converter.format(this.date(2001, 1, 1), sb);
        String expected = "2001-02-01T14:15:16,123";
        Assert.assertEquals((Object)"2001-02-01T14:15:16,123", (Object)sb.toString());
    }

    @Test
    public void testFormatDateStringBuilderIso8601WithPeriod() {
        String[] pattern = new String[]{FixedDateFormat.FixedFormat.ISO8601_PERIOD.name()};
        DatePatternConverter converter = DatePatternConverter.newInstance((String[])pattern);
        StringBuilder sb = new StringBuilder();
        converter.format(this.date(2001, 1, 1), sb);
        String expected = "2001-02-01T14:15:16.123";
        Assert.assertEquals((Object)"2001-02-01T14:15:16.123", (Object)sb.toString());
    }

    @Test
    public void testFormatDateStringBuilderIso8601BasicWithPeriod() {
        String[] pattern = new String[]{FixedDateFormat.FixedFormat.ISO8601_BASIC_PERIOD.name()};
        DatePatternConverter converter = DatePatternConverter.newInstance((String[])pattern);
        StringBuilder sb = new StringBuilder();
        converter.format(this.date(2001, 1, 1), sb);
        String expected = "20010201T141516.123";
        Assert.assertEquals((Object)"20010201T141516.123", (Object)sb.toString());
    }

    @Test
    public void testFormatDateStringBuilderOriginalPattern() {
        String[] pattern = new String[]{"yyyy/MM/dd HH-mm-ss.SSS"};
        DatePatternConverter converter = DatePatternConverter.newInstance((String[])pattern);
        StringBuilder sb = new StringBuilder();
        converter.format(this.date(2001, 1, 1), sb);
        String expected = "2001/02/01 14-15-16.123";
        Assert.assertEquals((Object)"2001/02/01 14-15-16.123", (Object)sb.toString());
    }

    @Test
    public void testFormatStringBuilderObjectArrayDefaultPattern() {
        DatePatternConverter converter = DatePatternConverter.newInstance(null);
        StringBuilder sb = new StringBuilder();
        converter.format(sb, new Object[]{this.date(2001, 1, 1), this.date(2002, 2, 2), this.date(2003, 3, 3)});
        String expected = "2001-02-01 14:15:16,123";
        Assert.assertEquals((Object)"2001-02-01 14:15:16,123", (Object)sb.toString());
    }

    @Test
    public void testFormatStringBuilderObjectArrayIso8601() {
        DatePatternConverter converter = DatePatternConverter.newInstance((String[])ISO8601_FORMAT_OPTIONS);
        StringBuilder sb = new StringBuilder();
        converter.format(sb, new Object[]{this.date(2001, 1, 1), this.date(2002, 2, 2), this.date(2003, 3, 3)});
        String expected = "2001-02-01T14:15:16,123";
        Assert.assertEquals((Object)"2001-02-01T14:15:16,123", (Object)sb.toString());
    }

    private Date date(int year, int month, int date) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, date, 14, 15, 16);
        cal.set(14, 123);
        return cal.getTime();
    }

    @Test
    public void testGetPatternReturnsDefaultForNullOptions() {
        Assert.assertEquals((Object)DEFAULT_PATTERN, (Object)DatePatternConverter.newInstance(null).getPattern());
    }

    @Test
    public void testGetPatternReturnsDefaultForEmptyOptionsArray() {
        Assert.assertEquals((Object)DEFAULT_PATTERN, (Object)DatePatternConverter.newInstance((String[])new String[0]).getPattern());
    }

    @Test
    public void testGetPatternReturnsDefaultForSingleNullElementOptionsArray() {
        Assert.assertEquals((Object)DEFAULT_PATTERN, (Object)DatePatternConverter.newInstance((String[])new String[1]).getPattern());
    }

    @Test
    public void testGetPatternReturnsDefaultForTwoNullElementsOptionsArray() {
        Assert.assertEquals((Object)DEFAULT_PATTERN, (Object)DatePatternConverter.newInstance((String[])new String[2]).getPattern());
    }

    @Test
    public void testGetPatternReturnsDefaultForInvalidPattern() {
        String[] invalid = new String[]{"ABC I am not a valid date pattern"};
        Assert.assertEquals((Object)DEFAULT_PATTERN, (Object)DatePatternConverter.newInstance((String[])invalid).getPattern());
    }

    @Test
    public void testGetPatternReturnsNullForUnix() {
        String[] options = new String[]{"UNIX"};
        Assert.assertNull((Object)DatePatternConverter.newInstance((String[])options).getPattern());
    }

    @Test
    public void testGetPatternReturnsNullForUnixMillis() {
        String[] options = new String[]{"UNIX_MILLIS"};
        Assert.assertNull((Object)DatePatternConverter.newInstance((String[])options).getPattern());
    }

    private class MyLogEvent
    extends AbstractLogEvent {
        private static final long serialVersionUID = 0L;

        private MyLogEvent() {
        }

        public long getTimeMillis() {
            Calendar cal = Calendar.getInstance();
            cal.set(2011, 11, 30, 10, 56, 35);
            cal.set(14, 987);
            return cal.getTimeInMillis();
        }

        public Instant getInstant() {
            MutableInstant result = new MutableInstant();
            result.initFromEpochMilli(this.getTimeMillis(), 123456);
            return result;
        }
    }
}

