/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.mock;

import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.logging.log4j.core.net.mock.MockSyslogServer;

public class MockTcpSyslogServer
extends MockSyslogServer {
    private final ServerSocket sock;
    private volatile boolean shutdown = false;
    private Thread thread;

    public MockTcpSyslogServer(int numberOfMessagesToReceive, int port) throws IOException {
        super(numberOfMessagesToReceive, port);
        this.sock = new ServerSocket(port);
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        try {
            this.sock.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.thread.interrupt();
        try {
            this.thread.join(100L);
        }
        catch (InterruptedException ie) {
            System.out.println("Shutdown of TCP server thread failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.println("TCP Server started");
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            try {
                byte[] buffer = new byte[4096];
                Socket socket = null;
                try {
                    socket = this.sock.accept();
                    socket.setSoLinger(true, 0);
                    InputStream in = socket.getInputStream();
                    int i = in.read(buffer, 0, buffer.length);
                    while (i != -1) {
                        if (i < buffer.length) {
                            String line = new String(buffer, 0, i);
                            this.messageList.add(line);
                            i = in.read(buffer, 0, buffer.length);
                            continue;
                        }
                        if (i == 0) {
                            System.out.println("No data received");
                            continue;
                        }
                        System.out.println("Message too long");
                    }
                }
                catch (BindException be) {
                    be.printStackTrace();
                }
                finally {
                    if (socket == null) continue;
                    socket.close();
                }
            }
            catch (Exception ex) {
                if (this.shutdown) continue;
                System.out.println("Caught exception: " + ex.getMessage());
            }
        }
        System.out.println("TCP Server stopped");
    }
}

