/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.MarkerFilter;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class MarkerFilterTest {
    @Test
    public void testMarkers() {
        Marker parent = MarkerManager.getMarker((String)"Parent");
        Marker child = MarkerManager.getMarker((String)"Child").setParents(new Marker[]{parent});
        Marker grandChild = MarkerManager.getMarker((String)"GrandChild").setParents(new Marker[]{child});
        Marker sibling = MarkerManager.getMarker((String)"Sibling").setParents(new Marker[]{parent});
        Marker stranger = MarkerManager.getMarker((String)"Stranger");
        MarkerFilter filter = MarkerFilter.createFilter((String)"Parent", null, null);
        filter.start();
        Assert.assertTrue((boolean)filter.isStarted());
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, null, stranger, (Object)null, (Throwable)null));
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, null, child, (Object)null, (Throwable)null));
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, null, grandChild, (Object)null, (Throwable)null));
        filter.stop();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setMarker(grandChild).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event));
        filter = MarkerFilter.createFilter((String)"Child", null, null);
        filter.start();
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event));
        event = Log4jLogEvent.newBuilder().setMarker(sibling).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event));
        filter.stop();
    }
}

