/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.xml;

import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class XmlConfigurationPropsTest {
    private static final String CONFIG = "log4j-props.xml";
    private static final String CONFIG1 = "log4j-props1.xml";

    @AfterClass
    public static void cleanupClass() {
        System.clearProperty("log4j.configurationFile");
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
        StatusLogger.getLogger().reset();
    }

    @Test
    public void testNoProps() {
        System.setProperty("log4j.configurationFile", CONFIG);
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
        Configuration config = ctx.getConfiguration();
        Assert.assertTrue((String)"Configuration is not an XmlConfiguration", (boolean)(config instanceof XmlConfiguration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultStatus() {
        System.setProperty("log4j.configurationFile", CONFIG1);
        System.setProperty("Log4jDefaultStatusLevel", "WARN");
        try {
            LoggerContext ctx = LoggerContext.getContext();
            ctx.reconfigure();
            Configuration config = ctx.getConfiguration();
            Assert.assertTrue((String)"Configuration is not an XmlConfiguration", (boolean)(config instanceof XmlConfiguration));
        }
        finally {
            System.clearProperty("Log4jDefaultStatusLevel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithConfigProp() {
        System.setProperty("log4j.configurationFile", CONFIG);
        System.setProperty("log4j.level", "warn");
        try {
            LoggerContext ctx = LoggerContext.getContext();
            ctx.reconfigure();
            Configuration config = ctx.getConfiguration();
            Assert.assertTrue((String)"Configuration is not an XmlConfiguration", (boolean)(config instanceof XmlConfiguration));
        }
        finally {
            System.clearProperty("log4j.level");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithProps() {
        System.setProperty("log4j.configurationFile", CONFIG);
        System.setProperty("log4j.level", "warn");
        System.setProperty("log.level", "warn");
        try {
            LoggerContext ctx = LoggerContext.getContext();
            ctx.reconfigure();
            Configuration config = ctx.getConfiguration();
            Assert.assertTrue((String)"Configuration is not an XmlConfiguration", (boolean)(config instanceof XmlConfiguration));
        }
        finally {
            System.clearProperty("log4j.level");
            System.clearProperty("log.level");
        }
    }
}

