/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.validation;

import java.net.InetSocketAddress;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidHost;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidPort;

@Plugin(name="HostAndPort", category="Test")
public class HostAndPort {
    private final InetSocketAddress address;

    private HostAndPort(InetSocketAddress address) {
        this.address = address;
    }

    public boolean isValid() {
        return !this.address.isUnresolved();
    }

    @PluginFactory
    public static HostAndPort createPlugin(@ValidHost(message="Unit test (host)") @PluginAttribute(value="host") String host, @ValidPort(message="Unit test (port)") @PluginAttribute(value="port") int port) {
        return new HostAndPort(new InetSocketAddress(host, port));
    }

    public String toString() {
        return "HostAndPort{address=" + this.address + '}';
    }
}

