/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class LoggerConfigTest {
    private static LoggerConfig createForProperties(Property[] properties) {
        return LoggerConfig.createLogger((boolean)true, (Level)Level.INFO, (String)"name", (String)"false", (AppenderRef[])new AppenderRef[0], (Property[])properties, (Configuration)new NullConfiguration(), null);
    }

    @Test
    public void testPropertiesWithoutSubstitution() {
        Assert.assertNull((String)"null propertiesList", (Object)LoggerConfigTest.createForProperties(null).getPropertyList());
        Assert.assertNull((String)"null property Map", (Object)LoggerConfigTest.createForProperties(null).getProperties());
        Property[] all = new Property[]{Property.createProperty((String)"key1", (String)"value1"), Property.createProperty((String)"key2", (String)"value2")};
        LoggerConfig loggerConfig = LoggerConfigTest.createForProperties(all);
        List list = loggerConfig.getPropertyList();
        Assert.assertEquals((String)"map and list contents equal", new HashSet(list), new HashSet(loggerConfig.getPropertyList()));
        final Object[] actualList = new Object[1];
        loggerConfig.setLogEventFactory(new LogEventFactory(){

            public LogEvent createEvent(String loggerName, Marker marker, String fqcn, Level level, Message data, List<Property> properties, Throwable t) {
                actualList[0] = properties;
                return new Log4jLogEvent.Builder().setTimeMillis(System.currentTimeMillis()).build();
            }
        });
        loggerConfig.log("name", "fqcn", null, Level.INFO, (Message)new SimpleMessage("msg"), null);
        Assert.assertSame((String)"propertiesList passed in as is if no substitutions required", (Object)list, (Object)actualList[0]);
    }

    @Test
    public void testPropertiesWithSubstitution() {
        Property[] all = new Property[]{Property.createProperty((String)"key1", (String)"value1-${sys:user.name}"), Property.createProperty((String)"key2", (String)"value2-${sys:user.name}")};
        LoggerConfig loggerConfig = LoggerConfigTest.createForProperties(all);
        List list = loggerConfig.getPropertyList();
        Assert.assertEquals((String)"map and list contents equal", new HashSet(list), new HashSet(loggerConfig.getPropertyList()));
        final Object[] actualListHolder = new Object[1];
        loggerConfig.setLogEventFactory(new LogEventFactory(){

            public LogEvent createEvent(String loggerName, Marker marker, String fqcn, Level level, Message data, List<Property> properties, Throwable t) {
                actualListHolder[0] = properties;
                return new Log4jLogEvent.Builder().setTimeMillis(System.currentTimeMillis()).build();
            }
        });
        loggerConfig.log("name", "fqcn", null, Level.INFO, (Message)new SimpleMessage("msg"), null);
        Assert.assertNotSame((String)"propertiesList with substitutions", (Object)list, (Object)actualListHolder[0]);
        List actualList = (List)actualListHolder[0];
        for (int i = 0; i < list.size(); ++i) {
            Assert.assertEquals((String)("name[" + i + "]"), (Object)((Property)list.get(i)).getName(), (Object)((Property)actualList.get(i)).getName());
            String value = ((Property)list.get(i)).getValue().replace("${sys:user.name}", System.getProperty("user.name"));
            Assert.assertEquals((String)("value[" + i + "]"), (Object)value, (Object)((Property)actualList.get(i)).getValue());
        }
    }
}

