/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.status.StatusConsoleListener;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class CustomConfigurationTest {
    public static final String LOG_FILE = "target/test.log";
    @Rule
    public LoggerContextRule init = new LoggerContextRule("log4j-props.xml");

    @BeforeClass
    public static void before() {
        System.setProperty("log4j.level", "info");
        System.setProperty("log.level", "info");
    }

    @Before
    public void setUp() throws Exception {
        new File(LOG_FILE).delete();
    }

    @Test
    public void testConfig() {
        LoggerContext ctx = this.init.getLoggerContext();
        ctx.reconfigure();
        Configuration config = ctx.getConfiguration();
        Assert.assertThat((Object)config, (Matcher)Matchers.instanceOf(XmlConfiguration.class));
        for (StatusListener listener : StatusLogger.getLogger().getListeners()) {
            if (!(listener instanceof StatusConsoleListener)) continue;
            Assert.assertSame((Object)listener.getStatusLevel(), (Object)Level.INFO);
            break;
        }
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d [%t] %p %c - %m%n").withConfiguration(config).build();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(LOG_FILE).withAppend(false).withName("File")).withIgnoreExceptions(false)).withBufferSize(4000)).withBufferedIo(false)).withLayout((Layout)layout)).build();
        appender.start();
        config.addAppender((Appender)appender);
        AppenderRef ref = AppenderRef.createAppenderRef((String)"File", null, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.INFO, (String)"org.apache.logging.log4j", (String)"true", (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfig.addAppender((Appender)appender, null, null);
        config.addLogger("org.apache.logging.log4j", loggerConfig);
        ctx.updateLoggers();
        Logger logger = ctx.getLogger(CustomConfigurationTest.class.getName());
        logger.info("This is a test");
        File file = new File(LOG_FILE);
        Assert.assertThat((Object)file, FileMatchers.exists());
        Assert.assertThat((Object)file, FileMatchers.hasLength(Matchers.greaterThan((Comparable)Long.valueOf(0L))));
    }
}

