/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async.perftest;

import com.lmax.disruptor.collections.Histogram;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.perftest.IPerfTestRunner;

public class RunLog4j2
implements IPerfTestRunner {
    final Logger LOGGER = LogManager.getLogger(this.getClass());

    @Override
    public void runThroughputTest(int lines, Histogram histogram) {
        long s1 = System.nanoTime();
        Logger logger = this.LOGGER;
        for (int j = 0; j < lines; ++j) {
            logger.info("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456");
        }
        long s2 = System.nanoTime();
        long opsPerSec = 1000000000L * (long)lines / (s2 - s1);
        histogram.addObservation(opsPerSec);
    }

    @Override
    public void runLatencyTest(int samples, Histogram histogram, long nanoTimeCost, int threadCount) {
        Logger logger = this.LOGGER;
        for (int i = 0; i < samples; ++i) {
            long s1 = System.nanoTime();
            logger.info("Short msg");
            long s2 = System.nanoTime();
            long value = s2 - s1 - nanoTimeCost;
            if (value > 0L) {
                histogram.addObservation(value);
            }
            long PAUSE_NANOS = 10000 * threadCount;
            long pauseStart = System.nanoTime();
            while (PAUSE_NANOS > System.nanoTime() - pauseStart) {
            }
        }
    }

    @Override
    public void shutdown() {
        CoreLoggerContexts.stopLoggerContext();
    }

    @Override
    public void log(String finalMessage) {
        this.LOGGER.info(finalMessage);
    }
}

