/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.time.internal.FixedPreciseClock;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterConsumer;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.util.FilteredObjectInputStream;
import org.apache.logging.log4j.util.StringMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class RingBufferLogEventTest {
    @Test
    public void testToImmutable() {
        RingBufferLogEvent logEvent = new RingBufferLogEvent();
        Assert.assertNotSame((Object)logEvent, (Object)logEvent.toImmutable());
    }

    @Test
    public void testGetLevelReturnsOffIfNullLevelSet() {
        RingBufferLogEvent evt = new RingBufferLogEvent();
        String loggerName = null;
        Marker marker = null;
        String fqcn = null;
        Level level = null;
        Message data = null;
        Throwable t = null;
        ThreadContext.ContextStack contextStack = null;
        String threadName = null;
        StackTraceElement location = null;
        evt.setValues(null, loggerName, marker, fqcn, level, data, t, (StringMap)evt.getContextData(), contextStack, -1L, threadName, -1, location, (Clock)new FixedPreciseClock(), (NanoClock)new DummyNanoClock(1L));
        Assert.assertEquals((Object)Level.OFF, (Object)evt.getLevel());
    }

    @Test
    public void testGetMessageReturnsNonNullMessage() {
        RingBufferLogEvent evt = new RingBufferLogEvent();
        String loggerName = null;
        Marker marker = null;
        String fqcn = null;
        Level level = null;
        Message data = null;
        Throwable t = null;
        ThreadContext.ContextStack contextStack = null;
        String threadName = null;
        StackTraceElement location = null;
        evt.setValues(null, loggerName, marker, fqcn, level, data, t, (StringMap)evt.getContextData(), contextStack, -1L, threadName, -1, location, (Clock)new FixedPreciseClock(), (NanoClock)new DummyNanoClock(1L));
        Assert.assertNotNull((Object)evt.getMessage());
    }

    @Test
    public void testGetMillisReturnsConstructorMillisForNormalMessage() {
        RingBufferLogEvent evt = new RingBufferLogEvent();
        String loggerName = null;
        Marker marker = null;
        String fqcn = null;
        Level level = null;
        Message data = null;
        Throwable t = null;
        ThreadContext.ContextStack contextStack = null;
        String threadName = null;
        StackTraceElement location = null;
        evt.setValues(null, loggerName, marker, fqcn, level, data, t, (StringMap)evt.getContextData(), contextStack, -1L, threadName, -1, location, (Clock)new FixedPreciseClock(123L, 456), (NanoClock)new DummyNanoClock(1L));
        Assert.assertEquals((long)123L, (long)evt.getTimeMillis());
        Assert.assertEquals((long)456L, (long)evt.getInstant().getNanoOfMillisecond());
    }

    @Test
    public void testSerializationDeserialization() throws IOException, ClassNotFoundException {
        RingBufferLogEvent evt = new RingBufferLogEvent();
        String loggerName = "logger.name";
        Marker marker = null;
        String fqcn = "f.q.c.n";
        Level level = Level.TRACE;
        SimpleMessage data = new SimpleMessage("message");
        InternalError t = new InternalError("not a real error");
        ThreadContext.ContextStack contextStack = null;
        String threadName = "main";
        StackTraceElement location = null;
        evt.setValues(null, "logger.name", marker, "f.q.c.n", level, (Message)data, (Throwable)t, (StringMap)evt.getContextData(), contextStack, -1L, "main", -1, location, (Clock)new FixedPreciseClock(12345L, 678), (NanoClock)new DummyNanoClock(1L));
        ((StringMap)evt.getContextData()).putValue("key", (Object)"value");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(evt);
        FilteredObjectInputStream in = new FilteredObjectInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        RingBufferLogEvent other = (RingBufferLogEvent)in.readObject();
        Assert.assertEquals((Object)"logger.name", (Object)other.getLoggerName());
        Assert.assertEquals(marker, (Object)other.getMarker());
        Assert.assertEquals((Object)"f.q.c.n", (Object)other.getLoggerFqcn());
        Assert.assertEquals((Object)level, (Object)other.getLevel());
        Assert.assertEquals((Object)data, (Object)other.getMessage());
        Assert.assertNull((String)"null after serialization", (Object)other.getThrown());
        Assert.assertEquals((Object)new ThrowableProxy((Throwable)t), (Object)other.getThrownProxy());
        Assert.assertEquals((Object)evt.getContextData(), (Object)other.getContextData());
        Assert.assertEquals(contextStack, (Object)other.getContextStack());
        Assert.assertEquals((Object)"main", (Object)other.getThreadName());
        Assert.assertEquals(location, (Object)other.getSource());
        Assert.assertEquals((long)12345L, (long)other.getTimeMillis());
        Assert.assertEquals((long)678L, (long)other.getInstant().getNanoOfMillisecond());
    }

    @Test
    public void testCreateMementoReturnsCopy() {
        RingBufferLogEvent evt = new RingBufferLogEvent();
        String loggerName = "logger.name";
        Marker marker = MarkerManager.getMarker((String)"marked man");
        String fqcn = "f.q.c.n";
        Level level = Level.TRACE;
        SimpleMessage data = new SimpleMessage("message");
        InternalError t = new InternalError("not a real error");
        MutableThreadContextStack contextStack = new MutableThreadContextStack(Arrays.asList("a", "b"));
        String threadName = "main";
        StackTraceElement location = null;
        evt.setValues(null, "logger.name", marker, "f.q.c.n", level, (Message)data, (Throwable)t, (StringMap)evt.getContextData(), (ThreadContext.ContextStack)contextStack, -1L, "main", -1, location, (Clock)new FixedPreciseClock(12345L, 678), (NanoClock)new DummyNanoClock(1L));
        ((StringMap)evt.getContextData()).putValue("key", (Object)"value");
        LogEvent actual = evt.createMemento();
        Assert.assertEquals((Object)evt.getLoggerName(), (Object)actual.getLoggerName());
        Assert.assertEquals((Object)evt.getMarker(), (Object)actual.getMarker());
        Assert.assertEquals((Object)evt.getLoggerFqcn(), (Object)actual.getLoggerFqcn());
        Assert.assertEquals((Object)evt.getLevel(), (Object)actual.getLevel());
        Assert.assertEquals((Object)evt.getMessage(), (Object)actual.getMessage());
        Assert.assertEquals((Object)evt.getThrown(), (Object)actual.getThrown());
        Assert.assertEquals((Object)evt.getContextMap(), (Object)actual.getContextMap());
        Assert.assertEquals((Object)evt.getContextData(), (Object)actual.getContextData());
        Assert.assertEquals((Object)evt.getContextStack(), (Object)actual.getContextStack());
        Assert.assertEquals((Object)evt.getThreadName(), (Object)actual.getThreadName());
        Assert.assertEquals((long)evt.getTimeMillis(), (long)actual.getTimeMillis());
        Assert.assertEquals((long)evt.getInstant().getNanoOfMillisecond(), (long)actual.getInstant().getNanoOfMillisecond());
        Assert.assertEquals((Object)evt.getSource(), (Object)actual.getSource());
        Assert.assertEquals((Object)evt.getThrownProxy(), (Object)actual.getThrownProxy());
    }

    @Test
    public void testMessageTextNeverThrowsNpe() {
        RingBufferLogEvent evt = new RingBufferLogEvent();
        try {
            evt.getFormattedMessage();
        }
        catch (NullPointerException e) {
            Assert.fail((String)"the messageText field was not set");
        }
    }

    @Test
    public void testForEachParameterNothingSet() {
        RingBufferLogEvent evt = new RingBufferLogEvent();
        evt.forEachParameter((ParameterConsumer)new ParameterConsumer<Void>(){

            public void accept(Object parameter, int parameterIndex, Void state) {
                Assert.fail((String)"Should not have been called");
            }
        }, null);
    }
}

