/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.junit.CleanFiles;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Category(value={AsyncLoggers.class})
public class AsyncRootReloadTest {
    private static final String ISSUE = "LOG4J2-807";
    private static final String ISSUE_CONFIG = "LOG4J2-807.xml";
    private static final String LOG = "target/LOG4J2-807.log";
    private static final String RESOURCE = "classpath:LOG4J2-807.xml";
    @ClassRule
    public static RuleChain rules = RuleChain.outerRule((TestRule)new CleanFiles("target/LOG4J2-807.log")).around((TestRule)new LoggerContextRule("classpath:LOG4J2-807.xml"));

    @Test
    public void testLog4j2_807() throws InterruptedException, URISyntaxException {
        URL url = AsyncRootReloadTest.class.getResource("/LOG4J2-807.xml");
        File configFile = FileUtils.fileFromUri((URI)url.toURI());
        Logger logger = LogManager.getLogger(AsyncRootReloadTest.class);
        logger.info("Log4j configured, will be reconfigured in aprox. 5 sec");
        configFile.setLastModified(System.currentTimeMillis());
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            logger.info("Log4j waiting for reconfiguration");
        }
    }
}

