/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.attribute.BasicFileAttributes;
import org.apache.logging.log4j.core.appender.rolling.action.CountingCondition;
import org.apache.logging.log4j.core.appender.rolling.action.DummyFileAttributes;
import org.apache.logging.log4j.core.appender.rolling.action.IfAccumulatedFileSize;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.junit.Assert;
import org.junit.Test;

public class IfAccumulatedFileSizeTest {
    @Test
    public void testGetThresholdBytes() {
        Assert.assertEquals((long)2L, (long)IfAccumulatedFileSizeTest.create("2B").getThresholdBytes());
        Assert.assertEquals((long)3L, (long)IfAccumulatedFileSizeTest.create("3 B").getThresholdBytes());
        Assert.assertEquals((long)2048L, (long)IfAccumulatedFileSizeTest.create("2KB").getThresholdBytes());
        Assert.assertEquals((long)3072L, (long)IfAccumulatedFileSizeTest.create("3 KB").getThresholdBytes());
        Assert.assertEquals((long)0x200000L, (long)IfAccumulatedFileSizeTest.create("2MB").getThresholdBytes());
        Assert.assertEquals((long)0x300000L, (long)IfAccumulatedFileSizeTest.create("3 MB").getThresholdBytes());
        Assert.assertEquals((long)0x80000000L, (long)IfAccumulatedFileSizeTest.create("2GB").getThresholdBytes());
        Assert.assertEquals((long)0xC0000000L, (long)IfAccumulatedFileSizeTest.create("3 GB").getThresholdBytes());
    }

    private static IfAccumulatedFileSize create(String size) {
        return IfAccumulatedFileSize.createFileSizeCondition((String)size, (PathCondition[])new PathCondition[0]);
    }

    @Test
    public void testNotAcceptOnExactMatch() {
        String[] sizes;
        for (String size : sizes = new String[]{"2KB", "3MB", "4GB"}) {
            IfAccumulatedFileSize condition = IfAccumulatedFileSize.createFileSizeCondition((String)size, (PathCondition[])new PathCondition[0]);
            DummyFileAttributes attribs = new DummyFileAttributes();
            attribs.size = condition.getThresholdBytes();
            Assert.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        }
    }

    @Test
    public void testAcceptIfExceedThreshold() {
        String[] sizes;
        for (String size : sizes = new String[]{"2KB", "3MB", "4GB"}) {
            IfAccumulatedFileSize condition = IfAccumulatedFileSize.createFileSizeCondition((String)size, (PathCondition[])new PathCondition[0]);
            DummyFileAttributes attribs = new DummyFileAttributes();
            attribs.size = condition.getThresholdBytes() + 1L;
            Assert.assertTrue((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        }
    }

    @Test
    public void testNotAcceptIfBelowThreshold() {
        String[] sizes;
        for (String size : sizes = new String[]{"2KB", "3MB", "4GB"}) {
            IfAccumulatedFileSize condition = IfAccumulatedFileSize.createFileSizeCondition((String)size, (PathCondition[])new PathCondition[0]);
            DummyFileAttributes attribs = new DummyFileAttributes();
            attribs.size = condition.getThresholdBytes() - 1L;
            Assert.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        }
    }

    @Test
    public void testAcceptOnceThresholdExceeded() {
        String[] sizes;
        DummyFileAttributes attribs = new DummyFileAttributes();
        for (String size : sizes = new String[]{"2KB", "3MB", "4GB"}) {
            long quarter;
            IfAccumulatedFileSize condition = IfAccumulatedFileSize.createFileSizeCondition((String)size, (PathCondition[])new PathCondition[0]);
            attribs.size = quarter = condition.getThresholdBytes() / 4L;
            Assert.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
            Assert.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
            Assert.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
            Assert.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
            Assert.assertTrue((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        }
    }

    @Test
    public void testAcceptCallsNestedConditionsOnlyIfPathAccepted() {
        long quarter;
        CountingCondition counter = new CountingCondition(true);
        IfAccumulatedFileSize condition = IfAccumulatedFileSize.createFileSizeCondition((String)"2KB", (PathCondition[])new PathCondition[]{counter});
        DummyFileAttributes attribs = new DummyFileAttributes();
        attribs.size = quarter = condition.getThresholdBytes() / 4L;
        Assert.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        Assert.assertEquals((long)0L, (long)counter.getAcceptCount());
        Assert.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        Assert.assertEquals((long)0L, (long)counter.getAcceptCount());
        Assert.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        Assert.assertEquals((long)0L, (long)counter.getAcceptCount());
        Assert.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        Assert.assertEquals((long)0L, (long)counter.getAcceptCount());
        Assert.assertTrue((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        Assert.assertEquals((long)1L, (long)counter.getAcceptCount());
        Assert.assertTrue((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        Assert.assertEquals((long)2L, (long)counter.getAcceptCount());
    }

    @Test
    public void testBeforeTreeWalk() {
        CountingCondition counter = new CountingCondition(true);
        IfAccumulatedFileSize filter = IfAccumulatedFileSize.createFileSizeCondition((String)"2GB", (PathCondition[])new PathCondition[]{counter, counter, counter});
        filter.beforeFileTreeWalk();
        Assert.assertEquals((long)3L, (long)counter.getBeforeFileTreeWalkCount());
    }
}

