/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractDatabaseAppenderTest {
    private LocalAbstractDatabaseAppender appender;
    @Mock
    private LocalAbstractDatabaseManager manager;

    public void setUp(String name) {
        this.appender = new LocalAbstractDatabaseAppender(name, null, true, this.manager);
    }

    @Test
    public void testNameAndGetLayout01() {
        this.setUp("testName01");
        Assert.assertEquals((String)"The name is not correct.", (Object)"testName01", (Object)this.appender.getName());
        Assert.assertNull((String)"The layout should always be null.", (Object)this.appender.getLayout());
    }

    @Test
    public void testNameAndGetLayout02() {
        this.setUp("anotherName02");
        Assert.assertEquals((String)"The name is not correct.", (Object)"anotherName02", (Object)this.appender.getName());
        Assert.assertNull((String)"The layout should always be null.", (Object)this.appender.getLayout());
    }

    @Test
    public void testStartAndStop() throws Exception {
        this.setUp("name");
        this.appender.start();
        ((LocalAbstractDatabaseManager)((Object)BDDMockito.then((Object)((Object)this.manager)).should())).startupInternal();
        this.appender.stop();
        ((LocalAbstractDatabaseManager)((Object)BDDMockito.then((Object)((Object)this.manager)).should())).stop(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testReplaceManager() throws Exception {
        this.setUp("name");
        LocalAbstractDatabaseManager oldManager = (LocalAbstractDatabaseManager)this.appender.getManager();
        Assert.assertSame((String)"The manager should be the same.", (Object)((Object)this.manager), (Object)((Object)oldManager));
        LocalAbstractDatabaseManager newManager = (LocalAbstractDatabaseManager)((Object)Mockito.mock(LocalAbstractDatabaseManager.class));
        this.appender.replaceManager(newManager);
        ((LocalAbstractDatabaseManager)((Object)BDDMockito.then((Object)((Object)this.manager)).should())).close();
        ((LocalAbstractDatabaseManager)((Object)BDDMockito.then((Object)((Object)newManager)).should())).startupInternal();
        this.appender.stop();
        ((LocalAbstractDatabaseManager)((Object)BDDMockito.then((Object)((Object)newManager)).should())).stop(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testAppend() {
        this.setUp("name");
        BDDMockito.given((Object)this.manager.commitAndClose()).willReturn((Object)true);
        LogEvent event1 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event2 = (LogEvent)Mockito.mock(LogEvent.class);
        this.appender.append(event1);
        ((LocalAbstractDatabaseManager)((Object)BDDMockito.then((Object)((Object)this.manager)).should())).connectAndStart();
        ((LocalAbstractDatabaseManager)((Object)BDDMockito.then((Object)((Object)this.manager)).should())).writeInternal((LogEvent)ArgumentMatchers.same((Object)event1), (Serializable)ArgumentMatchers.isNull());
        ((LocalAbstractDatabaseManager)((Object)BDDMockito.then((Object)((Object)this.manager)).should())).commitAndClose();
        Mockito.reset((Object[])new LocalAbstractDatabaseManager[]{this.manager});
        this.appender.append(event2);
        ((LocalAbstractDatabaseManager)((Object)BDDMockito.then((Object)((Object)this.manager)).should())).connectAndStart();
        ((LocalAbstractDatabaseManager)((Object)BDDMockito.then((Object)((Object)this.manager)).should())).writeInternal((LogEvent)ArgumentMatchers.same((Object)event2), (Serializable)ArgumentMatchers.isNull());
        ((LocalAbstractDatabaseManager)((Object)BDDMockito.then((Object)((Object)this.manager)).should())).commitAndClose();
    }

    private static class LocalAbstractDatabaseAppender
    extends AbstractDatabaseAppender<LocalAbstractDatabaseManager> {
        public LocalAbstractDatabaseAppender(String name, Filter filter, boolean exceptionSuppressed, LocalAbstractDatabaseManager manager) {
            super(name, filter, exceptionSuppressed, (AbstractDatabaseManager)manager);
        }
    }

    private static abstract class LocalAbstractDatabaseManager
    extends AbstractDatabaseManager {
        public LocalAbstractDatabaseManager(String name, int bufferSize) {
            super(name, bufferSize);
        }
    }
}

