/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.List;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.categories.Scripts;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Scripts.Groovy.class})
public class ScriptAppenderSelectorTest {
    @Rule
    public final LoggerContextRule loggerContextRule;

    @Parameterized.Parameters(name="{0}")
    public static Object[][] getParameters() {
        return new Object[][]{{"log4j-appender-selector-groovy.xml"}, {"log4j-appender-selector-javascript.xml"}};
    }

    public ScriptAppenderSelectorTest(String configLocation) {
        this.loggerContextRule = new LoggerContextRule(configLocation);
    }

    private ListAppender getListAppender() {
        return this.loggerContextRule.getListAppender("SelectIt");
    }

    private void logAndCheck() {
        Marker marker = MarkerManager.getMarker((String)"HEXDUMP");
        Logger logger = this.loggerContextRule.getLogger(ScriptAppenderSelectorTest.class);
        logger.error("Hello");
        ListAppender listAppender = this.getListAppender();
        List<LogEvent> list = listAppender.getEvents();
        Assert.assertNotNull((String)"No events generated", list);
        Assert.assertTrue((String)("Incorrect number of events. Expected 1, got " + list.size()), (list.size() == 1 ? 1 : 0) != 0);
        logger.error("World");
        Assert.assertTrue((String)("Incorrect number of events. Expected 2, got " + list.size()), (list.size() == 2 ? 1 : 0) != 0);
        logger.error(marker, "DEADBEEF");
        Assert.assertTrue((String)("Incorrect number of events. Expected 3, got " + list.size()), (list.size() == 3 ? 1 : 0) != 0);
    }

    @Test(expected=AssertionError.class)
    public void testAppender1Absence() {
        this.loggerContextRule.getListAppender("List1");
    }

    @Test(expected=AssertionError.class)
    public void testAppender2Absence() {
        this.loggerContextRule.getListAppender("List2");
    }

    @Test
    public void testAppenderPresence() {
        this.getListAppender();
    }

    @Test
    public void testLogging1() {
        this.logAndCheck();
    }

    @Test
    public void testLogging2() {
        this.logAndCheck();
    }
}

