/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.message.ReusableParameterizedMessage;
import org.apache.logging.log4j.message.StringFormatterMessageFactory;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.MessageFactory2Adapter;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class LoggerTest {
    private static final String CONFIG = "log4j-test2.xml";
    @Rule
    public final TestName testName = new TestName();
    private ListAppender app;
    private ListAppender host;
    private ListAppender noThrown;
    @Rule
    public LoggerContextRule context = new LoggerContextRule("log4j-test2.xml");
    Logger logger;
    Logger loggerChild;
    Logger loggerGrandchild;

    private void assertEventCount(List<LogEvent> events, int expected) {
        Assert.assertEquals((String)"Incorrect number of events.", (long)expected, (long)events.size());
    }

    @Before
    public void before() {
        this.logger = this.context.getLogger("LoggerTest");
        this.loggerChild = this.context.getLogger("LoggerTest.child");
        this.loggerGrandchild = this.context.getLogger("LoggerTest.child.grand");
        this.app = this.context.getListAppender("List").clear();
        this.host = this.context.getListAppender("HostTest").clear();
        this.noThrown = this.context.getListAppender("NoThrowable").clear();
    }

    @Test
    public void basicFlow() {
        this.logger.traceEntry();
        this.logger.traceExit();
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 2);
    }

    @Test
    public void simpleFlow() {
        this.logger.entry(new Object[]{CONFIG});
        this.logger.traceExit((Object)0);
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 2);
    }

    @Test
    public void simpleFlowDepreacted() {
        this.logger.entry(new Object[]{CONFIG});
        this.logger.exit((Object)0);
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 2);
    }

    @Test
    public void throwing() {
        this.logger.throwing((Throwable)new IllegalArgumentException("Test Exception"));
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
    }

    @Test
    public void catching() {
        try {
            throw new NullPointerException();
        }
        catch (Exception e) {
            this.logger.catching((Throwable)e);
            List<LogEvent> events = this.app.getEvents();
            this.assertEventCount(events, 1);
            return;
        }
    }

    @Test
    public void debug() {
        this.logger.debug("Debug message");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
    }

    @Test
    public void debugChangeLevel() {
        this.logger.debug("Debug message 1");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
        Configurator.setLevel((String)this.logger.getName(), (Level)Level.OFF);
        this.logger.debug("Debug message 2");
        this.assertEventCount(events, 1);
        Configurator.setLevel((String)this.logger.getName(), (Level)Level.DEBUG);
        this.logger.debug("Debug message 3");
        this.assertEventCount(events, 2);
    }

    @Test
    public void debugChangeLevelAllChildrenLoggers() {
        this.logger.debug("Debug message 1");
        this.loggerChild.debug("Debug message 1 child");
        this.loggerGrandchild.debug("Debug message 1 grandchild");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 3);
        Configurator.setAllLevels((String)this.logger.getName(), (Level)Level.OFF);
        this.logger.debug("Debug message 2");
        this.loggerChild.warn("Warn message 2 child");
        this.loggerGrandchild.fatal("Fatal message 2 grandchild");
        this.assertEventCount(events, 3);
        Configurator.setAllLevels((String)this.logger.getName(), (Level)Level.DEBUG);
        this.logger.debug("Debug message 3");
        this.loggerChild.warn("Trace message 3 child");
        this.loggerGrandchild.trace("Fatal message 3 grandchild");
        this.assertEventCount(events, 5);
    }

    @Test
    public void debugChangeLevelChildLogger() {
        this.logger.debug("Debug message 1");
        this.loggerChild.debug("Debug message 1 child");
        this.loggerGrandchild.debug("Debug message 1 grandchild");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 3);
        Configurator.setLevel((String)this.logger.getName(), (Level)Level.OFF);
        this.logger.debug("Debug message 2");
        this.loggerChild.debug("Debug message 2 child");
        this.loggerGrandchild.debug("Debug message 2 grandchild");
        this.assertEventCount(events, 3);
        Configurator.setLevel((String)this.logger.getName(), (Level)Level.DEBUG);
        this.logger.debug("Debug message 3");
        this.loggerChild.debug("Debug message 3 child");
        this.loggerGrandchild.debug("Debug message 3 grandchild");
        this.assertEventCount(events, 6);
    }

    @Test
    public void debugChangeLevelsChildLoggers() {
        org.apache.logging.log4j.core.Logger loggerChild = this.context.getLogger(this.logger.getName() + ".child");
        this.logger.debug("Debug message 1");
        loggerChild.debug("Debug message 1 child");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 2);
        Configurator.setLevel((String)this.logger.getName(), (Level)Level.ERROR);
        Configurator.setLevel((String)loggerChild.getName(), (Level)Level.DEBUG);
        this.logger.debug("Debug message 2");
        loggerChild.debug("Debug message 2 child");
        this.assertEventCount(events, 3);
        Configurator.setLevel((String)this.logger.getName(), (Level)Level.DEBUG);
        this.logger.debug("Debug message 3");
        loggerChild.debug("Debug message 3 child");
        this.assertEventCount(events, 5);
    }

    @Test
    public void debugChangeLevelsMap() {
        this.logger.debug("Debug message 1");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
        HashMap<String, Level> map = new HashMap<String, Level>();
        map.put(this.logger.getName(), Level.OFF);
        Configurator.setLevel(map);
        this.logger.debug("Debug message 2");
        this.assertEventCount(events, 1);
        map.put(this.logger.getName(), Level.DEBUG);
        Configurator.setLevel(map);
        this.logger.debug("Debug message 3");
        this.assertEventCount(events, 2);
    }

    @Test
    public void debugChangeLevelsMapChildLoggers() {
        this.logger.debug("Debug message 1");
        this.loggerChild.debug("Debug message 1 C");
        this.loggerGrandchild.debug("Debug message 1 GC");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 3);
        HashMap<String, Level> map = new HashMap<String, Level>();
        map.put(this.logger.getName(), Level.OFF);
        map.put(this.loggerChild.getName(), Level.DEBUG);
        map.put(this.loggerGrandchild.getName(), Level.WARN);
        Configurator.setLevel(map);
        this.logger.debug("Debug message 2");
        this.loggerChild.debug("Debug message 2 C");
        this.loggerGrandchild.debug("Debug message 2 GC");
        this.assertEventCount(events, 4);
        map.put(this.logger.getName(), Level.DEBUG);
        map.put(this.loggerChild.getName(), Level.OFF);
        map.put(this.loggerGrandchild.getName(), Level.DEBUG);
        Configurator.setLevel(map);
        this.logger.debug("Debug message 3");
        this.loggerChild.debug("Debug message 3 C");
        this.loggerGrandchild.debug("Debug message 3 GC");
        this.assertEventCount(events, 6);
    }

    @Test
    public void debugChangeRootLevel() {
        this.logger.debug("Debug message 1");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
        Configurator.setRootLevel((Level)Level.OFF);
        this.logger.debug("Debug message 2");
        this.assertEventCount(events, 1);
        Configurator.setRootLevel((Level)Level.DEBUG);
        this.logger.debug("Debug message 3");
        this.assertEventCount(events, 2);
    }

    @Test
    public void getLogger_String_MessageFactoryMismatch() {
        org.apache.logging.log4j.core.Logger testLogger = LoggerTest.testMessageFactoryMismatch(this.testName.getMethodName(), (MessageFactory)StringFormatterMessageFactory.INSTANCE, (MessageFactory)ParameterizedMessageFactory.INSTANCE);
        testLogger.debug("%,d", (Object)Integer.MAX_VALUE);
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
        Assert.assertEquals((Object)String.format("%,d", Integer.MAX_VALUE), (Object)events.get(0).getMessage().getFormattedMessage());
    }

    @Test
    public void getLogger_String_MessageFactoryMismatchNull() {
        org.apache.logging.log4j.core.Logger testLogger = LoggerTest.testMessageFactoryMismatch(this.testName.getMethodName(), (MessageFactory)StringFormatterMessageFactory.INSTANCE, null);
        testLogger.debug("%,d", (Object)Integer.MAX_VALUE);
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
        Assert.assertEquals((Object)String.format("%,d", Integer.MAX_VALUE), (Object)events.get(0).getMessage().getFormattedMessage());
    }

    private static org.apache.logging.log4j.core.Logger testMessageFactoryMismatch(String name, MessageFactory messageFactory1, MessageFactory messageFactory2) {
        org.apache.logging.log4j.core.Logger testLogger1 = (org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)name, (MessageFactory)messageFactory1);
        Assert.assertNotNull((Object)testLogger1);
        LoggerTest.checkMessageFactory(messageFactory1, testLogger1);
        org.apache.logging.log4j.core.Logger testLogger2 = (org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)name, (MessageFactory)messageFactory2);
        Assert.assertNotNull((Object)testLogger2);
        LoggerTest.checkMessageFactory(messageFactory2, testLogger2);
        return testLogger1;
    }

    private static void checkMessageFactory(MessageFactory messageFactory1, org.apache.logging.log4j.core.Logger testLogger1) {
        if (messageFactory1 == null) {
            Assert.assertEquals((Object)AbstractLogger.DEFAULT_MESSAGE_FACTORY_CLASS, testLogger1.getMessageFactory().getClass());
        } else {
            MessageFactory actual = testLogger1.getMessageFactory();
            if (actual instanceof MessageFactory2Adapter) {
                actual = ((MessageFactory2Adapter)actual).getOriginal();
            }
            Assert.assertEquals((Object)messageFactory1, (Object)actual);
        }
    }

    @Test
    public void debugObject() {
        this.logger.debug((Object)new Date());
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
    }

    @Test
    public void debugWithParms() {
        this.logger.debug("Hello, {}", (Object)"World");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
    }

    @Test
    public void testImpliedThrowable() {
        org.apache.logging.log4j.core.Logger testLogger = this.context.getLogger("org.apache.logging.log4j.hosttest");
        testLogger.debug("This is a test", new Throwable("Testing"));
        List<String> msgs = this.host.getMessages();
        Assert.assertEquals((String)("Incorrect number of messages. Expected 1, actual " + msgs.size()), (long)1L, (long)msgs.size());
        String expected = "java.lang.Throwable: Testing";
        Assert.assertTrue((String)"Incorrect message data", (boolean)msgs.get(0).contains("java.lang.Throwable: Testing"));
    }

    @Test
    public void testSuppressedThrowable() {
        org.apache.logging.log4j.core.Logger testLogger = this.context.getLogger("org.apache.logging.log4j.nothrown");
        testLogger.debug("This is a test", new Throwable("Testing"));
        List<String> msgs = this.noThrown.getMessages();
        Assert.assertEquals((String)("Incorrect number of messages. Expected 1, actual " + msgs.size()), (long)1L, (long)msgs.size());
        String suppressed = "java.lang.Throwable: Testing";
        Assert.assertTrue((String)"Incorrect message data", (!msgs.get(0).contains("java.lang.Throwable: Testing") ? 1 : 0) != 0);
    }

    @Test
    public void mdc() {
        ThreadContext.put((String)"TestYear", (String)"2010");
        this.logger.debug("Debug message");
        ThreadContext.clearMap();
        this.logger.debug("Debug message");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 2);
    }

    @Test
    public void structuredData() {
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        StructuredDataMessage msg = new StructuredDataMessage("Audit@18060", "Transfer Complete", "Transfer");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "123457");
        msg.put("Amount", "200.00");
        this.logger.info(MarkerManager.getMarker((String)"EVENT"), (Message)msg);
        ThreadContext.clearMap();
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
    }

    @Test
    public void testReconfiguration() throws Exception {
        int i;
        Configuration oldConfig = this.context.getConfiguration();
        int MONITOR_INTERVAL_SECONDS = 5;
        File file = new File("target/test-classes/log4j-test2.xml");
        long orig = file.lastModified();
        long newTime = orig + 10000L;
        Assert.assertTrue((String)"setLastModified should have succeeded.", (boolean)file.setLastModified(newTime));
        TimeUnit.SECONDS.sleep(6L);
        for (i = 0; i < 17; ++i) {
            this.logger.debug("Reconfigure");
        }
        Thread.sleep(100L);
        for (i = 0; i < 20 && this.context.getConfiguration() == oldConfig; ++i) {
            Thread.sleep(50L);
        }
        Configuration newConfig = this.context.getConfiguration();
        Assert.assertNotNull((String)"No configuration", (Object)newConfig);
        Assert.assertNotSame((String)"Reconfiguration failed", (Object)newConfig, (Object)oldConfig);
    }

    @Test
    public void testAdditivity() throws Exception {
        org.apache.logging.log4j.core.Logger localLogger = this.context.getLogger("org.apache.test");
        localLogger.error("Test parent additivity");
        List<LogEvent> events = this.app.getEvents();
        this.assertEventCount(events, 1);
    }

    @Test
    public void testLevelInheritence() throws Exception {
        Configuration config = this.context.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("org.apache.logging.log4j.core.LoggerTest");
        Assert.assertNotNull((Object)loggerConfig);
        Assert.assertEquals((Object)loggerConfig.getName(), (Object)"org.apache.logging.log4j.core.LoggerTest");
        Assert.assertEquals((Object)loggerConfig.getLevel(), (Object)Level.DEBUG);
        org.apache.logging.log4j.core.Logger localLogger = this.context.getLogger("org.apache.logging.log4j.core.LoggerTest");
        Assert.assertTrue((String)("Incorrect level - expected DEBUG, actual " + localLogger.getLevel()), (localLogger.getLevel() == Level.DEBUG ? 1 : 0) != 0);
    }

    @Test
    public void paramWithExceptionTest() throws Exception {
        this.logger.error("Throwing with parameters {}", (Object)"TestParam", (Object)new NullPointerException("Test Exception"));
        List<LogEvent> events = this.app.getEvents();
        Assert.assertNotNull((String)"Log event list not returned", events);
        Assert.assertTrue((String)("Incorrect number of log events: expected 1, actual " + events.size()), (events.size() == 1 ? 1 : 0) != 0);
        LogEvent event = events.get(0);
        Throwable thrown = event.getThrown();
        Assert.assertNotNull((String)"No throwable present in log event", (Object)thrown);
        Message msg = event.getMessage();
        Assert.assertTrue((String)("Incorrect message type. Expected ParameterizedMessage/ReusableParameterizedMessage, actual " + msg.getClass().getSimpleName()), (msg instanceof ParameterizedMessage || msg instanceof ReusableParameterizedMessage ? 1 : 0) != 0);
    }
}

