/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class LevelTest {
    private static final String CONFIG = "log4j-Level.xml";
    private ListAppender listAll;
    private ListAppender listTrace;
    private ListAppender listDebug;
    private ListAppender listInfo;
    private ListAppender listWarn;
    private ListAppender listError;
    private ListAppender listFatal;
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-Level.xml");

    @Before
    public void before() {
        this.listAll = context.getListAppender("ListAll").clear();
        this.listTrace = context.getListAppender("ListTrace").clear();
        this.listDebug = context.getListAppender("ListDebug").clear();
        this.listInfo = context.getListAppender("ListInfo").clear();
        this.listWarn = context.getListAppender("ListWarn").clear();
        this.listError = context.getListAppender("ListError").clear();
        this.listFatal = context.getListAppender("ListFatal").clear();
    }

    @Test
    public void testLevelLogging() {
        Expected[] expectedResults;
        Marker marker = MarkerManager.getMarker((String)"marker");
        ObjectMessage msg = new ObjectMessage((Object)"msg");
        Throwable t = new Throwable("test");
        Level[] levels = new Level[]{Level.TRACE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL};
        String[] names = new String[]{"levelTest", "levelTest.Trace", "levelTest.Debug", "levelTest.Info", "levelTest.Warn", "levelTest.Error", "levelTest.Fatal"};
        for (Level level : levels) {
            for (String name : names) {
                Logger logger = context.getLogger(name);
                logger.log(level, (Message)msg);
                logger.log(level, (Object)123);
                logger.log(level, name);
                logger.log(level, marker, (Message)msg);
                logger.log(level, marker, (Object)123);
                logger.log(level, marker, name);
                logger.log(level, (Message)msg, t);
                logger.log(level, (Object)123, t);
                logger.log(level, name, (Object)"param1", (Object)"param2");
                logger.log(level, name, t);
                logger.log(level, marker, (Message)msg, t);
                logger.log(level, marker, (Object)123, t);
                logger.log(level, marker, name, (Object)"param1", (Object)"param2");
                logger.log(level, marker, name, t);
            }
        }
        int levelCount = names.length - 1;
        int UNIT = 14;
        for (Expected expected : expectedResults = new Expected[]{new Expected(this.listAll, 14 * levelCount, "TRACE", "All"), new Expected(this.listTrace, 14 * levelCount--, "TRACE", "Trace"), new Expected(this.listDebug, 14 * levelCount--, "DEBUG", "Debug"), new Expected(this.listInfo, 14 * levelCount--, "INFO", "Info"), new Expected(this.listWarn, 14 * levelCount--, "WARN", "Warn"), new Expected(this.listError, 14 * levelCount--, "ERROR", "Error"), new Expected(this.listFatal, 14 * levelCount--, "FATAL", "Fatal")}) {
            String description = expected.description;
            List<LogEvent> events = expected.appender.getEvents();
            Assert.assertNotNull((String)(description + ": No events"), events);
            Assert.assertThat(events, (Matcher)Matchers.hasSize((int)expected.expectedEventCount));
            LogEvent event = events.get(0);
            Assert.assertEquals((String)(description + ": Expected level " + expected.expectedInitialEventLevel + ", got" + event.getLevel()), (Object)event.getLevel().name(), (Object)expected.expectedInitialEventLevel);
        }
    }

    private static class Expected {
        final ListAppender appender;
        final int expectedEventCount;
        final String expectedInitialEventLevel;
        final String description;

        Expected(ListAppender appender, int expectedCount, String level, String description) {
            this.appender = appender;
            this.expectedEventCount = expectedCount;
            this.expectedInitialEventLevel = level;
            this.description = description;
        }
    }
}

