/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class CustomLevelsOverrideTest {
    private static final String CONFIG = "log4j-customLevels.xml";
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-customLevels.xml");
    private ListAppender listAppender;
    private Level warnLevel;
    private Level infoLevel;
    private Level debugLevel;

    @Before
    public void before() {
        this.warnLevel = Level.getLevel((String)"WARN");
        this.infoLevel = Level.getLevel((String)"INFO");
        this.debugLevel = Level.getLevel((String)"DEBUG");
        this.listAppender = context.getListAppender("List1").clear();
    }

    @Test
    public void testCustomLevelInts() {
        Assert.assertNotEquals((long)350L, (long)this.warnLevel.intLevel());
        Assert.assertNotEquals((long)450L, (long)this.infoLevel.intLevel());
        Assert.assertNotEquals((long)550L, (long)this.debugLevel.intLevel());
    }

    @Test
    public void testCustomLevelPresence() {
        Assert.assertNotNull((Object)this.warnLevel);
        Assert.assertNotNull((Object)this.infoLevel);
        Assert.assertNotNull((Object)this.debugLevel);
    }

    @Test
    public void testCustomLevelVsStdLevel() {
        Assert.assertEquals((Object)Level.WARN, (Object)this.warnLevel);
        Assert.assertEquals((Object)Level.INFO, (Object)this.infoLevel);
        Assert.assertEquals((Object)Level.DEBUG, (Object)this.debugLevel);
    }

    @Test
    public void testLog() {
        Logger logger = context.getLogger();
        List<LogEvent> events = this.listAppender.getEvents();
        Assert.assertThat(events, (Matcher)Matchers.hasSize((int)0));
        logger.debug("Hello, {}", (Object)"World");
        Assert.assertThat(events, (Matcher)Matchers.hasSize((int)1));
        logger.log(this.warnLevel, "Hello DIAG");
        Assert.assertThat(events, (Matcher)Matchers.hasSize((int)2));
        Assert.assertEquals((Object)events.get(1).getLevel(), (Object)this.warnLevel);
    }
}

