/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.util;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

final class XmlUtils {
    static final String XML_NAMESPACE = "http://logging.apache.org/log4j/changelog";
    static final String XML_SCHEMA_LOCATION = "https://logging.apache.org/log4j/changelog-0.1.3.xsd";

    private XmlUtils() {
    }

    static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = XmlUtils.createSecureDocumentBuilderFactory();
        Schema schema = XmlUtils.readSchema();
        dbf.setSchema(schema);
        dbf.setValidating(true);
        return dbf;
    }

    private static DocumentBuilderFactory createSecureDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        String feature = null;
        try {
            feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(feature, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException error) {
            String message = String.format("`%s` is probably not supported by your XML processor", feature);
            throw new RuntimeException(message, error);
        }
        return dbf;
    }

    private static Schema readSchema() {
        String schemaFileName = "/log4j-changelog.xsd";
        InputStream schemaInputStream = XmlUtils.class.getResourceAsStream("/log4j-changelog.xsd");
        if (schemaInputStream == null) {
            String message = String.format("could not find the schema file resource: `%s`", "/log4j-changelog.xsd");
            throw new RuntimeException(message);
        }
        try {
            StreamSource schemaSource = new StreamSource(schemaInputStream);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            return schemaFactory.newSchema(schemaSource);
        }
        catch (Exception error) {
            String message = String.format("failed to load schema from file resource: `%s`", "/log4j-changelog.xsd");
            throw new RuntimeException(message, error);
        }
    }
}

