/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.releaser;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.changelog.ChangelogFiles;
import org.apache.logging.log4j.changelog.ChangelogRelease;
import org.apache.logging.log4j.changelog.releaser.ChangelogReleaserArgs;
import org.apache.logging.log4j.changelog.util.FileUtils;

public final class ChangelogReleaser {
    private ChangelogReleaser() {
    }

    public static void performRelease(ChangelogReleaserArgs args) {
        String releaseDate = DateTimeFormatter.ISO_DATE.format(args.releaseDate != null ? args.releaseDate : LocalDate.now());
        System.out.format("using `%s` for the release date%n", releaseDate);
        try {
            Path unreleasedDirectory = ChangelogFiles.unreleasedDirectory(args.changelogDirectory, args.releaseVersionMajor);
            Path releaseDirectory = ChangelogFiles.releaseDirectory(args.changelogDirectory, args.releaseVersion);
            ChangelogReleaser.populateReleaseChangelogEntryFiles(unreleasedDirectory, releaseDirectory);
            ChangelogReleaser.populateReleaseXmlFiles(releaseDate, args.releaseVersion, releaseDirectory);
            ChangelogReleaser.populateReleaseChangelogTemplateFiles(unreleasedDirectory, releaseDirectory);
        }
        catch (IOException error) {
            throw new UncheckedIOException(error);
        }
    }

    private static void populateReleaseChangelogEntryFiles(Path unreleasedDirectory, Path releaseDirectory) throws IOException {
        if (!Files.exists(releaseDirectory, new LinkOption[0])) {
            Files.createDirectories(releaseDirectory, new FileAttribute[0]);
        }
        FileUtils.findAdjacentFiles(unreleasedDirectory, true, paths -> {
            paths.forEach(unreleasedChangelogEntryFile -> {
                String fileName = unreleasedChangelogEntryFile.getFileName().toString();
                Path releasedChangelogEntryFile = releaseDirectory.resolve(fileName);
                System.out.format("moving changelog entry file `%s` to `%s`%n", unreleasedChangelogEntryFile, releasedChangelogEntryFile);
                try {
                    Files.move(unreleasedChangelogEntryFile, releasedChangelogEntryFile, new CopyOption[0]);
                }
                catch (IOException error) {
                    throw new UncheckedIOException(error);
                }
            });
            return 1;
        });
    }

    private static void populateReleaseXmlFiles(String releaseDate, String releaseVersion, Path releaseDirectory) throws IOException {
        Path releaseXmlFile = ChangelogFiles.releaseXmlFile(releaseDirectory);
        System.out.format("writing release information to `%s`%n", releaseXmlFile);
        ChangelogRelease changelogRelease = new ChangelogRelease(releaseVersion, releaseDate);
        Files.deleteIfExists(releaseXmlFile);
        changelogRelease.writeToXmlFile(releaseXmlFile);
    }

    private static void populateReleaseChangelogTemplateFiles(Path unreleasedDirectory, Path releaseDirectory) throws IOException {
        Set<String> releaseChangelogTemplateFileNames = ChangelogReleaser.releaseChangelogTemplateFileNames(unreleasedDirectory);
        for (String releaseChangelogTemplateFileName : releaseChangelogTemplateFileNames) {
            Path targetFile = releaseDirectory.resolve(releaseChangelogTemplateFileName);
            if (Files.exists(targetFile, new LinkOption[0])) {
                System.out.format("keeping the existing changelog template file: `%s`%n", targetFile);
                continue;
            }
            Path sourceFile = unreleasedDirectory.resolve(releaseChangelogTemplateFileName);
            System.out.format("copying the changelog template file `%s` to `%s`%n", sourceFile, targetFile);
            Files.copy(sourceFile, targetFile, new CopyOption[0]);
        }
    }

    private static Set<String> releaseChangelogTemplateFileNames(Path releaseDirectory) {
        String templateFileNameSuffix = '.' + ChangelogFiles.templateFileNameExtension();
        return FileUtils.findAdjacentFiles(releaseDirectory, false, paths -> paths.map(path -> path.getFileName().toString()).filter(path -> path.endsWith(templateFileNameSuffix)).collect(Collectors.toSet()));
    }
}

