/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.plugin;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.audit.generator.InterfacesGenerator;
import org.apache.logging.log4j.catalog.api.CatalogReader;
import org.apache.logging.log4j.catalog.api.dao.JsonCatalogReader;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class AuditMojo
extends AbstractMojo {
    private static final String BASEDIR = "baseDir";
    private static final String BUILDDIR = "buildDir";
    private static final int MAX_KEY_LENGTH = 32;
    private static final int DEFAULT_ENTERPRISE_ID = 18060;
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="catalogReaderClassName", defaultValue="org.apache.logging.log4j.catalog.api.dao.FileCatalogReader")
    private String catalogReaderClassName;
    @Parameter(property="catalogReaderAttributes", required=false)
    private Map<String, String> catalogReaderAttributes;
    @Parameter(property="packageName", required=true)
    private String packageName;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/log4j-audit", property="outputDir")
    private File outputDirectory;
    @Parameter(required=false)
    private int maxKeyLength;
    @Parameter(required=false)
    private int enterpriseId;

    public void execute() throws MojoExecutionException {
        if (this.maxKeyLength <= 0) {
            this.maxKeyLength = 32;
        }
        if (this.enterpriseId <= 0) {
            this.enterpriseId = 18060;
        }
        CatalogReader catalogReader = null;
        try {
            Constructor<?>[] constructors;
            File basedir = this.project.getBasedir();
            Class clazz = LoaderUtil.loadClass((String)this.catalogReaderClassName);
            for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                if (constructor.getParameterCount() != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(Map.class)) continue;
                if (this.catalogReaderAttributes == null) {
                    this.catalogReaderAttributes = new HashMap<String, String>();
                }
                if (!this.catalogReaderAttributes.containsKey(BASEDIR)) {
                    this.catalogReaderAttributes.put(BASEDIR, this.project.getBasedir().getAbsolutePath());
                }
                if (!this.catalogReaderAttributes.containsKey(BUILDDIR)) {
                    this.catalogReaderAttributes.put(BUILDDIR, this.project.getBuild().getDirectory());
                }
                catalogReader = (CatalogReader)constructor.newInstance(this.catalogReaderAttributes);
                break;
            }
            if (catalogReader == null) {
                catalogReader = (CatalogReader)LoaderUtil.newInstanceOf((String)this.catalogReaderClassName);
            }
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)("Unable to load catalog reader " + this.catalogReaderClassName), (Throwable)ex);
            return;
        }
        InterfacesGenerator generator = new InterfacesGenerator();
        JsonCatalogReader jsonCatalogReader = new JsonCatalogReader();
        jsonCatalogReader.setCatalogReader(catalogReader);
        jsonCatalogReader.init();
        generator.setCatalogReader((CatalogReader)jsonCatalogReader);
        generator.setOutputDirectory(this.outputDirectory.getAbsolutePath());
        generator.setPackageName(this.packageName);
        generator.setMaxKeyLength(this.maxKeyLength);
        generator.setEnterpriseId(this.enterpriseId);
        try {
            generator.generateSource();
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error generating Audit interfaces", ex);
        }
    }
}

