/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.rest;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.audit.request.ChainedMapping;
import org.apache.logging.log4j.audit.request.RequestContextMapping;
import org.apache.logging.log4j.audit.request.RequestContextMappings;
import org.apache.logging.log4j.audit.rest.ElapsedUtil;

public class RequestContextFilter
implements Filter {
    private static final Logger logger = LogManager.getLogger(RequestContextFilter.class);
    private final Class<?> requestContextClass;
    private RequestContextMappings mappings;

    public RequestContextFilter() {
        this.requestContextClass = null;
    }

    public RequestContextFilter(Class<?> clazz) {
        this.requestContextClass = clazz;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.requestContextClass != null) {
            this.mappings = new RequestContextMappings(this.requestContextClass);
        } else {
            String requestContextClassName = filterConfig.getInitParameter("requestContextClass");
            if (requestContextClassName == null) {
                logger.error("No RequestContext class name was provided");
                throw new IllegalArgumentException("No RequestContext class name provided");
            }
            this.mappings = new RequestContextMappings(requestContextClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            logger.info("Starting request {}" + request.getRequestURI());
            try {
                Enumeration headers = request.getHeaderNames();
                while (headers.hasMoreElements()) {
                    String name = (String)headers.nextElement();
                    RequestContextMapping mapping = this.mappings.getMappingByHeader(name);
                    logger.debug("Got Mapping:{} for Header:{}", (Object)mapping, (Object)name);
                    if (mapping == null) continue;
                    if (mapping.isChained()) {
                        ThreadContext.put((String)mapping.getChainKey(), (String)request.getHeader(name));
                        logger.debug("Setting Context Key:{} with value:{}", (Object)mapping.getChainKey(), (Object)request.getHeader(name));
                        String value = ((ChainedMapping)mapping).getSupplier().get();
                        ThreadContext.put((String)mapping.getFieldName(), (String)value);
                        logger.debug("Setting Context Key:{} with value:{}", (Object)mapping.getFieldName(), (Object)value);
                        continue;
                    }
                    ThreadContext.put((String)mapping.getFieldName(), (String)request.getHeader(name));
                    logger.debug("Setting Context Key:{} with value:{}", (Object)mapping.getFieldName(), (Object)request.getHeader(name));
                }
                long start = System.nanoTime();
                filterChain.doFilter(servletRequest, servletResponse);
                long elapsed = System.nanoTime() - start;
                StringBuilder sb = new StringBuilder("Request ").append(request.getRequestURI()).append(" completed in ");
                ElapsedUtil.addElapsed(elapsed, sb);
                logger.info(sb.toString());
            }
            catch (Throwable e) {
                logger.error("Application cascaded error", e);
                response.setStatus(500);
            }
            finally {
                ThreadContext.clearMap();
            }
        }
    }

    public void destroy() {
    }
}

