/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.EventLogger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.audit.AuditEvent;
import org.apache.logging.log4j.audit.AuditExceptionHandler;
import org.apache.logging.log4j.audit.AuditMessage;
import org.apache.logging.log4j.audit.annotation.Constraint;
import org.apache.logging.log4j.audit.annotation.Constraints;
import org.apache.logging.log4j.audit.annotation.MaxLength;
import org.apache.logging.log4j.audit.annotation.RequestContext;
import org.apache.logging.log4j.audit.annotation.RequestContextConstraints;
import org.apache.logging.log4j.audit.annotation.Required;
import org.apache.logging.log4j.audit.exception.AuditException;
import org.apache.logging.log4j.audit.util.NamingUtils;
import org.apache.logging.log4j.catalog.api.exception.ConstraintValidationException;
import org.apache.logging.log4j.catalog.api.plugins.ConstraintPlugins;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class LogEventFactory {
    private static final Logger logger = LogManager.getLogger(LogEventFactory.class);
    private static final String NAME = "AuditLogger";
    private static final String FQCN = LogEventFactory.class.getName();
    private static Marker EVENT_MARKER = MarkerManager.getMarker((String)"Audit").addParents(new Marker[]{EventLogger.EVENT_MARKER});
    private static final ExtendedLogger LOGGER = LogManager.getContext((boolean)false).getLogger("AuditLogger");
    private static final int DEFAULT_MAX_LENGTH = 32;
    private static final AuditExceptionHandler DEFAULT_HANDLER = (message, ex) -> {
        throw new AuditException("Error logging event " + message.getId().getName(), ex);
    };
    private static final AuditExceptionHandler NOOP_EXCEPTION_HANDLER = (message, ex) -> {};
    private static AuditExceptionHandler defaultExceptionHandler = DEFAULT_HANDLER;
    private static ConcurrentMap<Class<?>, List<Property>> classMap = new ConcurrentHashMap();
    private static ConstraintPlugins constraintPlugins = ConstraintPlugins.getInstance();

    public static void setDefaultHandler(AuditExceptionHandler exceptionHandler) {
        defaultExceptionHandler = exceptionHandler == null ? NOOP_EXCEPTION_HANDLER : exceptionHandler;
    }

    public static <T> T getEvent(Class<T> intrface) {
        Class[] interfaces = new Class[]{intrface};
        String eventId = NamingUtils.lowerFirst(intrface.getSimpleName());
        int msgLength = intrface.getAnnotation(MaxLength.class).value();
        AuditMessage msg = new AuditMessage(eventId, msgLength);
        AuditEvent audit = (AuditEvent)Proxy.newProxyInstance(intrface.getClassLoader(), interfaces, (InvocationHandler)new AuditProxy(msg, intrface));
        return (T)audit;
    }

    public static void logEvent(Class<?> intrface, Map<String, String> properties) {
        LogEventFactory.logEvent(intrface, properties, DEFAULT_HANDLER);
    }

    public static void logEvent(Class<?> intrface, Map<String, String> properties, AuditExceptionHandler handler) {
        StringBuilder errors = new StringBuilder();
        LogEventFactory.validateContextConstraints(intrface, errors);
        String eventId = NamingUtils.lowerFirst(intrface.getSimpleName());
        int maxLength = intrface.getAnnotation(MaxLength.class).value();
        AuditMessage msg = new AuditMessage(eventId, maxLength);
        List<Property> props = LogEventFactory.getProperties(intrface);
        HashMap<String, Property> propertyMap = new HashMap<String, Property>();
        for (Property property : props) {
            propertyMap.put(property.name, property);
            if (property.isRequired && !properties.containsKey(property.name)) {
                if (errors.length() > 0) {
                    errors.append("\n");
                }
                errors.append("Required attribute ").append(property.name).append(" is missing from ").append(eventId);
            }
            if (!properties.containsKey(property.name)) continue;
            LogEventFactory.validateConstraints(false, property.constraints, property.name, properties, errors);
        }
        for (Map.Entry entry : properties.entrySet()) {
            if (propertyMap.containsKey(entry.getKey()) || errors.length() <= 0) continue;
            errors.append("Attribute ").append((String)entry.getKey()).append(" is not defined for ").append(eventId);
        }
        if (errors.length() > 0) {
            throw new ConstraintValidationException(errors.toString());
        }
        for (Map.Entry entry : properties.entrySet()) {
            msg.put((String)entry.getKey(), (String)entry.getValue());
        }
        LogEventFactory.logEvent(msg, handler);
    }

    public static void logEvent(AuditMessage msg, AuditExceptionHandler handler) {
        try {
            LOGGER.logIfEnabled(FQCN, Level.OFF, EVENT_MARKER, (Message)msg, null);
        }
        catch (Throwable ex) {
            if (handler == null) {
                handler = defaultExceptionHandler;
            }
            handler.handleException(msg, ex);
        }
    }

    public static List<String> getPropertyNames(String className) {
        ArrayList<String> names;
        Class<?> intrface = LogEventFactory.getClass(className);
        if (intrface != null) {
            List<Property> props = LogEventFactory.getProperties(intrface);
            names = new ArrayList(props.size());
            for (Property prop : props) {
                names.add(prop.name);
            }
        } else {
            names = new ArrayList<String>();
        }
        return names;
    }

    private static List<Property> getProperties(Class<?> intrface) {
        ArrayList<Property> props = (ArrayList<Property>)classMap.get(intrface);
        if (props != null) {
            return props;
        }
        props = new ArrayList<Property>();
        Method[] methods = intrface.getMethods();
        boolean isCompletionStatus = false;
        for (Method method : methods) {
            if (!method.getName().startsWith("set") || method.getName().equals("setAuditExceptionHandler")) continue;
            if (method.getName().equals("setCompletionStatus")) {
                isCompletionStatus = true;
            }
            String name = NamingUtils.lowerFirst(NamingUtils.getMethodShortName(method.getName()));
            Annotation[] annotations = method.getDeclaredAnnotations();
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            boolean isRequired = false;
            for (Annotation annotation : annotations) {
                if (annotation instanceof Constraint) {
                    constraints.add((Constraint)annotation);
                }
                if (!(annotation instanceof Required)) continue;
                isRequired = true;
            }
            props.add(new Property(name, isRequired, constraints));
        }
        if (!isCompletionStatus) {
            props.add(new Property("completionStatus", false, new ArrayList<Constraint>()));
        }
        classMap.putIfAbsent(intrface, props);
        return (List)classMap.get(intrface);
    }

    private static Class<?> getClass(String className) {
        try {
            Class<?> intrface = Class.forName(className);
            if (AuditEvent.class.isAssignableFrom(intrface)) {
                return intrface;
            }
            logger.error(className + " is not an AuditEvent");
        }
        catch (ClassNotFoundException cnfe) {
            logger.error("Unable to locate class {}", (Object)className);
        }
        return null;
    }

    private static void validateConstraints(boolean isRequestContext, Constraint[] constraints, String name, Map<String, String> properties, StringBuilder errors) {
        String value = isRequestContext ? ThreadContext.get((String)name) : properties.get(name);
        LogEventFactory.validateConstraints(isRequestContext, constraints, name, value, errors);
    }

    private static void validateConstraints(boolean isRequestContext, Constraint[] constraints, String name, String value, StringBuilder errors) {
        for (Constraint constraint : constraints) {
            constraintPlugins.validateConstraint(isRequestContext, constraint.constraintType(), name, value, constraint.constraintValue(), errors);
        }
    }

    private static void validateContextConstraints(Class<?> intrface, StringBuilder buffer) {
        RequestContextConstraints reqCtxConstraints = intrface.getAnnotation(RequestContextConstraints.class);
        if (reqCtxConstraints != null) {
            for (RequestContext ctx : reqCtxConstraints.value()) {
                LogEventFactory.validateContextConstraint(ctx, buffer);
            }
        } else {
            RequestContext ctx = intrface.getAnnotation(RequestContext.class);
            LogEventFactory.validateContextConstraint(ctx, buffer);
        }
    }

    private static void validateContextConstraint(RequestContext constraint, StringBuilder errors) {
        String value = ThreadContext.get((String)constraint.key());
        if (value != null) {
            LogEventFactory.validateConstraints(true, constraint.constraints(), constraint.key(), value, errors);
        } else if (constraint.required()) {
            org.apache.logging.log4j.catalog.api.util.StringUtils.appendNewline((StringBuilder)errors);
            errors.append("ThreadContext does not contain required key ").append(constraint.key());
        }
    }

    private static boolean isBlank(String value) {
        return value != null && value.length() > 0;
    }

    static /* synthetic */ AuditExceptionHandler access$300() {
        return DEFAULT_HANDLER;
    }

    private static class Property {
        private final String name;
        private final boolean isRequired;
        private final Constraint[] constraints;

        public Property(String name, boolean isRequired, List<Constraint> constraints) {
            this.name = name;
            this.constraints = constraints.toArray(new Constraint[constraints.size()]);
            this.isRequired = isRequired;
        }
    }

    private static class AuditProxy
    implements InvocationHandler {
        private final AuditMessage msg;
        private final Class<?> intrface;
        private AuditExceptionHandler auditExceptionHandler = LogEventFactory.access$300();

        AuditProxy(AuditMessage msg, Class<?> intrface) {
            this.msg = msg;
            this.intrface = intrface;
        }

        public AuditMessage getMessage() {
            return this.msg;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            String name;
            if (method.getName().equals("logEvent")) {
                Method[] methods;
                StringBuilder errors = new StringBuilder();
                LogEventFactory.validateContextConstraints(this.intrface, errors);
                StringBuilder missing = new StringBuilder();
                for (Method _method : methods = this.intrface.getMethods()) {
                    Annotation[] annotations;
                    String name2 = NamingUtils.lowerFirst(NamingUtils.getMethodShortName(_method.getName()));
                    for (Annotation annotation : annotations = _method.getDeclaredAnnotations()) {
                        if (!(annotation instanceof Required) || this.msg.get(name2) != null) continue;
                        if (missing.length() > 0) {
                            missing.append(", ");
                        }
                        missing.append(name2);
                    }
                }
                if (errors.length() > 0) {
                    if (missing.length() > 0) {
                        errors.append("\n");
                        errors.append("Required attributes are missing: ");
                        errors.append(missing.toString());
                    }
                } else if (missing.length() > 0) {
                    errors.append("Required attributes are missing: ");
                    errors = missing;
                }
                if (errors.length() > 0) {
                    throw new ConstraintValidationException("Event " + this.msg.getId().getName() + " has errors :\n" + errors.toString());
                }
                LogEventFactory.logEvent(this.msg, this.auditExceptionHandler);
            }
            if (method.getName().equals("setCompletionStatus")) {
                name = NamingUtils.lowerFirst(NamingUtils.getMethodShortName(method.getName()));
                if (objects == null || objects[0] == null) {
                    throw new IllegalArgumentException("Missing completion status");
                }
                this.msg.put(name, objects[0].toString());
            }
            if (method.getName().equals("setAuditExceptionHandler")) {
                if (objects == null || objects[0] == null) {
                    this.auditExceptionHandler = NOOP_EXCEPTION_HANDLER;
                } else if (objects[0] instanceof AuditExceptionHandler) {
                    this.auditExceptionHandler = (AuditExceptionHandler)objects[0];
                } else {
                    throw new IllegalArgumentException(objects[0] + " is not an " + AuditExceptionHandler.class.getName());
                }
            }
            if (method.getName().startsWith("set")) {
                String result;
                name = NamingUtils.lowerFirst(NamingUtils.getMethodShortName(method.getName()));
                if (objects == null || objects[0] == null) {
                    throw new IllegalArgumentException("No value to be set for " + name);
                }
                Annotation[] annotations = method.getDeclaredAnnotations();
                Class<?> returnType = method.getReturnType();
                StringBuilder errors = new StringBuilder();
                for (Annotation annotation : annotations) {
                    if (annotation instanceof Constraints) {
                        Constraints constraints = (Constraints)annotation;
                        LogEventFactory.validateConstraints(false, constraints.value(), name, objects[0].toString(), errors);
                        continue;
                    }
                    if (!(annotation instanceof Constraint)) continue;
                    Constraint constraint = (Constraint)annotation;
                    constraintPlugins.validateConstraint(false, constraint.constraintType(), name, objects[0].toString(), constraint.constraintValue(), errors);
                }
                if (errors.length() > 0) {
                    throw new ConstraintValidationException(errors.toString());
                }
                if (objects[0] instanceof List) {
                    result = StringUtils.join((Object[])objects, (String)", ");
                } else {
                    if (objects[0] instanceof Map) {
                        StructuredDataMessage extra = new StructuredDataMessage(name, null, null);
                        extra.putAll((Map)objects[0]);
                        this.msg.addContent(name, extra);
                        return null;
                    }
                    result = objects[0].toString();
                }
                this.msg.put(name, result);
            }
            return null;
        }
    }
}

