/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.audit.AuditExceptionHandler;
import org.apache.logging.log4j.audit.AuditMessage;
import org.apache.logging.log4j.audit.catalog.CatalogManager;
import org.apache.logging.log4j.audit.exception.AuditException;
import org.apache.logging.log4j.catalog.api.Attribute;
import org.apache.logging.log4j.catalog.api.Constraint;
import org.apache.logging.log4j.catalog.api.Event;
import org.apache.logging.log4j.catalog.api.plugins.ConstraintPlugins;
import org.apache.logging.log4j.message.StructuredDataMessage;

public abstract class AbstractEventLogger {
    private static final Logger logger = LogManager.getLogger(AbstractEventLogger.class);
    private static final int DEFAULT_MAX_LENGTH = 32;
    private static ConstraintPlugins constraintPlugins = ConstraintPlugins.getInstance();
    public CatalogManager catalogManager;
    private static final AuditExceptionHandler DEFAULT_EXCEPTION_HANDLER = (message, ex) -> {
        throw new AuditException("Error logging event " + message.getId().getName(), ex);
    };
    private static final AuditExceptionHandler NOOP_EXCEPTION_HANDLER = (message, ex) -> {};
    private AuditExceptionHandler defaultAuditExceptionHandler = DEFAULT_EXCEPTION_HANDLER;
    private final int maxLength;

    protected AbstractEventLogger() {
        this.maxLength = 32;
    }

    protected AbstractEventLogger(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setCatalogManager(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
    }

    public List<String> getAttributeNames(String eventId) {
        return this.catalogManager.getAttributeNames(eventId);
    }

    public void setDefaultAuditExceptionHandler(AuditExceptionHandler auditExceptionHandler) {
        this.defaultAuditExceptionHandler = auditExceptionHandler == null ? NOOP_EXCEPTION_HANDLER : auditExceptionHandler;
    }

    public void logEvent(String eventName, Map<String, String> attributes) {
        Event event = this.catalogManager.getEvent(eventName);
        if (event == null) {
            throw new AuditException("Unable to locate definition of audit event " + eventName);
        }
        this.logEvent(eventName, attributes, event, this.defaultAuditExceptionHandler);
    }

    public void logEvent(String eventName, String catalogId, Map<String, String> attributes) {
        Event event = this.catalogManager.getEvent(eventName, catalogId);
        if (event == null) {
            throw new AuditException("Unable to locate definition of audit event " + eventName);
        }
        this.logEvent(eventName, attributes, event, this.defaultAuditExceptionHandler);
    }

    public void logEvent(String eventName, Map<String, String> attributes, AuditExceptionHandler exceptionHandler) {
        Event event = this.catalogManager.getEvent(eventName);
        if (event == null) {
            throw new AuditException("Unable to locate definition of audit event " + eventName);
        }
        this.logEvent(eventName, attributes, event, exceptionHandler);
    }

    protected abstract void logEvent(StructuredDataMessage var1);

    private void logEvent(String eventName, Map<String, String> attributes, Event event, AuditExceptionHandler exceptionHandler) {
        AuditMessage msg = new AuditMessage(eventName, this.maxLength);
        StringBuilder missingAttributes = new StringBuilder();
        StringBuilder errors = new StringBuilder();
        for (Object eventAttribute : event.getAttributes()) {
            Attribute attr = this.catalogManager.getAttribute(eventAttribute.getName(), event.getCatalogId());
            if ((attr.isRequestContext() || !attr.isRequired()) && (eventAttribute.isRequired() == null || !eventAttribute.isRequired().booleanValue())) continue;
            String name = attr.getName();
            if (!attributes.containsKey(name)) {
                if (missingAttributes.length() > 0) {
                    missingAttributes.append(", ");
                }
                missingAttributes.append(name);
                continue;
            }
            if (attr.getConstraints() == null || attr.getConstraints().size() <= 0) continue;
            Constraint[] constraints = attr.getConstraints().toArray(new Constraint[attr.getConstraints().size()]);
            AbstractEventLogger.validateConstraints(false, constraints, name, attributes.get(name), errors);
        }
        Map<String, Attribute> attributeMap = this.catalogManager.getAttributes(eventName, event.getCatalogId());
        for (String name : attributes.keySet()) {
            if (attributeMap.containsKey(name) || name.equals("completionStatus")) continue;
            if (errors.length() > 0) {
                errors.append("\n");
            }
            errors.append("Attribute ").append(name).append(" is not defined for ").append(eventName);
        }
        if (missingAttributes.length() > 0) {
            if (errors.length() > 0) {
                errors.append("\n");
            }
            errors.append("Event ").append(eventName).append(" is missing required attribute(s) ").append(missingAttributes.toString());
        }
        if (errors.length() > 0) {
            throw new AuditException(errors.toString());
        }
        List<String> attributeNames = this.catalogManager.getAttributeNames(eventName, event.getCatalogId());
        StringBuilder buf = new StringBuilder();
        for (String attribute : attributes.keySet()) {
            if (attributeNames.contains(attribute)) continue;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(attribute);
        }
        if (buf.length() > 0) {
            throw new AuditException("Event " + eventName + " contains invalid attribute(s) " + buf.toString());
        }
        List<String> reqCtxAttrs = this.catalogManager.getRequiredContextAttributes(eventName, event.getCatalogId());
        if (reqCtxAttrs != null) {
            StringBuilder sb = new StringBuilder();
            for (String string : reqCtxAttrs) {
                if (ThreadContext.containsKey((String)string)) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(string);
            }
            if (sb.length() > 0) {
                throw new IllegalStateException("Event " + msg.getId().getName() + " is missing required RequestContextMapping values for " + sb.toString());
            }
        }
        Map<String, Attribute> reqCtxAttributes = this.catalogManager.getRequestContextAttributes();
        for (Map.Entry entry : ThreadContext.getImmutableContext().entrySet()) {
            Set constraintList;
            Attribute attribute = reqCtxAttributes.get(entry.getKey());
            if (attribute == null || (constraintList = attribute.getConstraints()) == null || constraintList.size() <= 0) continue;
            Constraint[] constraints = attribute.getConstraints().toArray(new Constraint[attribute.getConstraints().size()]);
            AbstractEventLogger.validateConstraints(true, constraints, (String)entry.getKey(), ThreadContext.get((String)((String)entry.getKey())), errors);
        }
        if (errors.length() > 0) {
            throw new AuditException("Event " + eventName + " has incorrect data in the Thread Context: " + errors.toString());
        }
        msg.putAll(attributes);
        try {
            this.logEvent(msg);
        }
        catch (Throwable ex) {
            if (exceptionHandler == null) {
                this.defaultAuditExceptionHandler.handleException(msg, ex);
            }
            exceptionHandler.handleException(msg, ex);
        }
    }

    private static void validateConstraints(boolean isRequestContext, Constraint[] constraints, String name, String value, StringBuilder errors) {
        for (Constraint constraint : constraints) {
            constraintPlugins.validateConstraint(isRequestContext, constraint.getConstraintType().getName(), name, value, constraint.getValue(), errors);
        }
    }
}

