/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.lens.driver.hive;

import java.util.List;

import org.apache.lens.server.api.driver.LensResultSetMetadata;

import org.apache.hive.service.cli.ColumnDescriptor;

import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * The top level Result Set metadata class which is used by the jackson to
 * serialize to JSON.
 */

/**
 * Instantiates a new hive result set metadata.
 */
@NoArgsConstructor
public class HiveResultSetMetadata extends LensResultSetMetadata {

  /** The columns. */
  @Setter
  private List<ColumnDescriptor> columns;

  @Override
  public List<ColumnDescriptor> getColumns() {
    return columns;
  }
}
