/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.lens.cube.parse;

import org.apache.lens.cube.metadata.MetastoreUtil;

import org.apache.hadoop.hive.ql.parse.ASTNode;

public interface QueryAST {

  String getSelectString();

  String getFromString();

  String getWhereString();

  String getHavingString();

  String getOrderByString();

  String getGroupByString();

  Integer getLimitValue();

  void setLimitValue(Integer integer);

  /**
   * @return the selectAST
   */

  ASTNode getSelectAST();

  /**
   * @param selectAST the selectAST to set
   */

  void setSelectAST(ASTNode selectAST);

  /**
   * @return the whereAST
   */

  ASTNode getWhereAST();

  /**
   * @param whereAST the whereAST to set
   */

  void setWhereAST(ASTNode whereAST);

  /**
   * @return the havingAST
   */

  ASTNode getHavingAST();

  /**
   * @param havingAST the havingAST to set
   */

  void setHavingAST(ASTNode havingAST);

  ASTNode getGroupByAST();

  void setGroupByAST(ASTNode havingAST);

  ASTNode getJoinAST();

  ASTNode getOrderByAST();

  void setOrderByAST(ASTNode node);

  void setJoinAST(ASTNode node);

  void setFromString(String fromString);

  void setWhereString(String whereString);

  default void copyFrom(QueryAST sourceAst) {
    setSelectAST(MetastoreUtil.copyAST(sourceAst.getSelectAST()));
    setWhereAST(MetastoreUtil.copyAST(sourceAst.getWhereAST()));
    if (sourceAst.getJoinAST() != null) {
      setJoinAST(MetastoreUtil.copyAST(sourceAst.getJoinAST()));
    }
    if (sourceAst.getGroupByAST() != null) {
      setGroupByAST(MetastoreUtil.copyAST(sourceAst.getGroupByAST()));
    }
    if (sourceAst.getHavingAST() != null) {
      setHavingAST(MetastoreUtil.copyAST(sourceAst.getHavingAST()));
    }
    if (sourceAst.getOrderByAST() != null) {
      setOrderByAST(MetastoreUtil.copyAST(sourceAst.getOrderByAST()));
    }
    setLimitValue(sourceAst.getLimitValue());
    setFromString(sourceAst.getFromString());
    setWhereString(sourceAst.getWhereString());
  }
}
