/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/
package org.apache.calcite.prepare;

import org.apache.calcite.jdbc.CalcitePrepare;

public class OnlyPrepareEarlyAbortException extends RuntimeException {
    
    private CalcitePrepare.Context context;
    private org.apache.calcite.jdbc.CalcitePrepare.ParseResult preparedResult;

    public OnlyPrepareEarlyAbortException(CalcitePrepare.Context context,
            org.apache.calcite.jdbc.CalcitePrepare.ParseResult preparedResult) {
        this.context = context;
        this.preparedResult = preparedResult;
    }

    public CalcitePrepare.Context getContext() {
        return context;
    }

    public CalcitePrepare.ParseResult getPreparedResult() {
        return preparedResult;
    }
}
