/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.gateway.services.topology;

import org.apache.hadoop.gateway.config.GatewayConfig;
import org.apache.hadoop.gateway.services.Service;
import org.apache.hadoop.gateway.topology.Topology;
import org.apache.hadoop.gateway.topology.TopologyListener;

import java.util.Collection;
import java.util.List;
import java.util.Map;


public interface TopologyService extends Service {

  public void reloadTopologies();

  public void deployTopology(Topology t);

  public void redeployTopologies(String topologyName);

  public void addTopologyChangeListener(TopologyListener listener);

  public void startMonitor() throws Exception;

  public void stopMonitor() throws Exception;

  public Collection<Topology> getTopologies();

  public void deleteTopology(Topology t);

  public Map<String, List<String>> getServiceTestURLs(Topology t, GatewayConfig config);

  }
