/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p/>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p/>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.gateway.ha.provider.impl;

/**
 * The constants for xml elements and attributes are meant to help render/consume the following:
 * <p/>
 * <ha>
 * <service name='foo' failoverLimit='3' enabled='true'/>
 * </ha>
 */
public interface HaDescriptorConstants {

   public static final String ROOT_ELEMENT = "ha";

   public static final String SERVICE_ELEMENT = "service";

   public static final String SERVICE_NAME_ATTRIBUTE = "name";

   public static final String MAX_FAILOVER_ATTEMPTS = "maxFailoverAttempts";

   public static final String FAILOVER_SLEEP = "failoverSleep";

   public static final String MAX_RETRY_ATTEMPTS = "maxRetryAttempts";

   public static final String RETRY_SLEEP = "retrySleep";

   public static final String ENABLED_ATTRIBUTE = "enabled";

   public static final String ZOOKEEPER_ENSEMBLE = "zookeeperEnsemble";

   public static final String ZOOKEEPER_NAMESPACE = "zookeeperNamespace";

}
