/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.gateway.audit.api;

import org.apache.hadoop.gateway.audit.log4j.audit.Log4jAuditService;

public abstract class AuditServiceFactory {

  // The global audit service instance.
  private static AuditService auditService = null;

  // To prevent instantiation.
  private AuditServiceFactory() {
  }

  /**
   * Provides access to the default audit service implementation.
   * @return The default audit service implementation.  Will not be null.
   */
  public static AuditService getAuditService() {
    // Race condition acceptable and will only result in multiple service instantiations.
    if( auditService == null ) {
      auditService = new Log4jAuditService();
    }
    return auditService;
  }

}
