/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.gateway.provider.federation.jwt;

import org.apache.hadoop.gateway.i18n.messages.Message;
import org.apache.hadoop.gateway.i18n.messages.MessageLevel;
import org.apache.hadoop.gateway.i18n.messages.Messages;

@Messages(logger="org.apache.hadoop.gateway.provider.federation.jwt")
public interface JWTMessages {
  @Message( level = MessageLevel.INFO, text = "Failed to validate the audience attribute." )
  void failedToValidateAudience();

  @Message( level = MessageLevel.INFO, text = "Failed to verify the token signature." )
  void failedToVerifyTokenSignature();

  @Message( level = MessageLevel.INFO, text = "Access token has expired; a new one must be acquired." )
  void tokenHasExpired();

  @Message( level = MessageLevel.INFO, text = "Expected Bearer token is missing." )
  void missingBearerToken();
}
