/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.repository;

import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.osgi.resource.ResourceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.repository.Repository;

public class AggregateRepository
extends BaseRepository {
    private final List<Repository> repositories;

    public AggregateRepository(Collection<? extends Repository> repositories) {
        this.repositories = new ArrayList<Repository>(repositories);
    }

    public AggregateRepository(Repository ... repositories) {
        this.repositories = new ArrayList<Repository>(repositories.length);
        Collections.addAll(this.repositories, repositories);
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        Map<Requirement, Collection<Capability>> result = ResourceUtils.findProviders(requirements, this::findProviders);
        return result;
    }

    public Collection<Capability> findProviders(Requirement requirement) {
        Set<Requirement> requirements = Collections.singleton(requirement);
        Collection capabilities = this.repositories.stream().map(repository -> (Collection)repository.findProviders(requirements).get(requirement)).reduce(new ArrayList(), ResourceUtils::capabilitiesCombiner);
        return capabilities;
    }
}

