/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonPatch;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import org.apache.johnzon.core.JsonPointerImpl;

class JsonPatchImpl
implements JsonPatch {
    private final JsonProvider provider;
    private final List<PatchValue> patches;
    private volatile JsonArray json;

    JsonPatchImpl(JsonProvider provider, PatchValue ... patches) {
        this(provider, Arrays.asList(patches));
    }

    JsonPatchImpl(JsonProvider provider, List<PatchValue> patches) {
        this.provider = provider;
        this.patches = patches == null ? Collections.emptyList() : Collections.unmodifiableList(patches);
    }

    @Override
    public <T extends JsonStructure> T apply(T target) {
        Object patched = target;
        block8: for (PatchValue patch : this.patches) {
            switch (patch.operation) {
                case ADD: {
                    patched = patch.path.add((JsonStructure)patched, patch.value);
                    continue block8;
                }
                case REMOVE: {
                    patched = patch.path.remove((JsonStructure)patched);
                    continue block8;
                }
                case REPLACE: {
                    patched = patch.path.add(patch.path.remove((JsonStructure)patched), patch.value);
                    continue block8;
                }
                case MOVE: {
                    JsonValue valueToMove = patch.from.getValue((JsonStructure)patched);
                    patched = patch.path.add(patch.from.remove((JsonStructure)patched), valueToMove);
                    continue block8;
                }
                case COPY: {
                    JsonValue toCopy = patch.from.getValue((JsonStructure)patched);
                    patched = patch.path.add((JsonStructure)patched, toCopy);
                    continue block8;
                }
                case TEST: {
                    JsonValue toTest = patch.path.getValue((JsonStructure)patched);
                    if (toTest.equals(patch.value)) continue block8;
                    throw new JsonException("JsonPatch.Operation.TEST fails! Values are not equal");
                }
            }
            throw new IllegalStateException("unsupported operation: " + (Object)((Object)patch.operation));
        }
        return patched;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPatchImpl jsonPatch = (JsonPatchImpl)o;
        return this.patches.equals(jsonPatch.patches);
    }

    public int hashCode() {
        return this.patches.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonArray toJsonArray() {
        if (this.patches.isEmpty()) {
            return JsonValue.EMPTY_JSON_ARRAY;
        }
        if (this.json == null) {
            JsonPatchImpl jsonPatchImpl = this;
            synchronized (jsonPatchImpl) {
                if (this.json == null) {
                    JsonArrayBuilder builder = this.provider.createArrayBuilder();
                    for (PatchValue patch : this.patches) {
                        builder.add(patch.toJson());
                    }
                    this.json = builder.build();
                }
            }
        }
        return this.json;
    }

    public String toString() {
        if (this.patches.isEmpty()) {
            return "[]";
        }
        return this.toJsonArray().toString();
    }

    static class PatchValue {
        private final JsonProvider provider;
        private final JsonPatch.Operation operation;
        private final JsonPointerImpl path;
        private final JsonPointerImpl from;
        private final JsonValue value;
        private volatile String str;
        private volatile JsonObject json;
        private volatile Integer hash;

        PatchValue(JsonProvider provider, JsonPatch.Operation operation, String path, String from, JsonValue value) {
            this.provider = provider;
            this.operation = operation;
            this.path = new JsonPointerImpl(provider, path);
            this.from = operation == JsonPatch.Operation.MOVE || operation == JsonPatch.Operation.COPY ? new JsonPointerImpl(provider, from) : null;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatchValue that = (PatchValue)o;
            if (this.operation != that.operation) {
                return false;
            }
            if (!this.path.equals(that.path)) {
                return false;
            }
            if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
                return false;
            }
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            if (this.hash == null) {
                PatchValue patchValue = this;
                synchronized (patchValue) {
                    if (this.hash == null) {
                        int result = this.operation.hashCode();
                        result = 31 * result + this.path.hashCode();
                        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
                        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                        this.hash = result;
                    }
                }
            }
            return this.hash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            if (this.str == null) {
                PatchValue patchValue = this;
                synchronized (patchValue) {
                    if (this.str == null) {
                        this.str = "{op: " + (Object)((Object)this.operation) + ", path: " + this.path + ", from: " + this.from + ", value: " + this.value + '}';
                    }
                }
            }
            return this.str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JsonObject toJson() {
            if (this.json == null) {
                PatchValue patchValue = this;
                synchronized (patchValue) {
                    if (this.json == null) {
                        JsonObjectBuilder builder = this.provider.createObjectBuilder().add("op", this.operation.name().toLowerCase()).add("path", this.path.getJsonPointer());
                        if (this.from != null) {
                            builder.add("from", this.from.getJsonPointer());
                        }
                        if (this.value != null) {
                            builder.add("value", this.value);
                        }
                        this.json = builder.build();
                    }
                }
            }
            return this.json;
        }
    }
}

