/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.core.impl;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.cm.json.Configurations;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.utils.collections.DictionaryAsMap;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfigInstaller
implements ArtifactInstaller,
ConfigurationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonConfigInstaller.class);
    private ConfigurationAdmin configurationAdmin;

    public JsonConfigInstaller(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public boolean canHandle(File artifact) {
        return artifact.getName().endsWith(".json");
    }

    public void install(File artifact) throws Exception {
        this.setConfig(artifact);
    }

    public void update(File artifact) throws Exception {
        this.setConfig(artifact);
    }

    public void uninstall(File artifact) throws Exception {
        this.deleteConfig(artifact);
    }

    private void setConfig(File artifact) throws Exception {
        String name = artifact.getName();
        String[] pid = this.parsePid(name);
        Configuration configuration = this.getConfiguration(this.toConfigKey(artifact), pid[0], pid[1]);
        Dictionary props = configuration.getProperties();
        Hashtable old = props != null ? new Hashtable(new DictionaryAsMap(props)) : null;
        Hashtable properties = Configurations.buildReader().build((Reader)new FileReader(artifact)).readConfiguration();
        if (old != null) {
            old.remove("felix.fileinstall.filename");
            old.remove("service.pid");
            old.remove("service.factoryPid");
        }
        if (old == null || !old.equals(properties)) {
            properties.put("felix.fileinstall.filename", this.toConfigKey(artifact));
            if (old == null) {
                LOGGER.info("Creating configuration from " + pid[0] + (pid[1] == null ? "" : "-" + pid[1]) + ".json");
            } else {
                LOGGER.info("Updating configuration from " + pid[0] + (pid[1] == null ? "" : "-" + pid[1]) + ".json");
            }
            configuration.update((Dictionary)properties);
        }
    }

    boolean deleteConfig(File f) throws Exception {
        String[] pid = this.parsePid(f.getName());
        LOGGER.info("Deleting configuration from " + pid[0] + (pid[1] == null ? "" : "-" + pid[1]) + ".json");
        Configuration config = this.getConfiguration(this.toConfigKey(f), pid[0], pid[1]);
        config.delete();
        return true;
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getType() == 2) {
            File file = new File(System.getProperty("karaf.etc"), event.getPid() + ".json");
            if (file.exists()) {
                file.delete();
            }
        } else if (event.getType() == 1) {
            try {
                Configuration configuration = this.configurationAdmin.getConfiguration(event.getPid(), null);
                Dictionary dictionary = configuration.getProcessedProperties(null);
                File file = null;
                if (dictionary.get("felix.fileinstall.filename") != null) {
                    file = this.getCfgFileFromProperty(configuration.getProperties().get("felix.fileinstall.filename"));
                }
                if (file != null && this.canHandle(file)) {
                    dictionary.remove("felix.fileinstall.filename");
                    dictionary.remove("service.pid");
                    dictionary.remove("service.factoryPid");
                    Configurations.buildWriter().build((Writer)new FileWriter(file)).writeConfiguration(dictionary);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Can't update json configuration file", (Throwable)e);
            }
        }
    }

    private File getCfgFileFromProperty(Object val) throws URISyntaxException, MalformedURLException {
        if (val instanceof URL) {
            return new File(((URL)val).toURI());
        }
        if (val instanceof URI) {
            return new File((URI)val);
        }
        if (val instanceof String) {
            return new File(new URL((String)val).toURI());
        }
        return null;
    }

    String[] parsePid(String path) {
        String pid = path.substring(0, path.lastIndexOf(46));
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    String toConfigKey(File f) {
        return f.getAbsoluteFile().toURI().toString();
    }

    Configuration getConfiguration(String fileName, String pid, String factoryPid) throws Exception {
        Configuration cachedConfiguration;
        Configuration oldConfiguration = this.findExistingConfiguration(fileName);
        Configuration configuration = cachedConfiguration = oldConfiguration != null ? this.configurationAdmin.getConfiguration(oldConfiguration.getPid(), null) : null;
        if (cachedConfiguration != null) {
            return cachedConfiguration;
        }
        Configuration newConfiguration = factoryPid != null ? this.configurationAdmin.createFactoryConfiguration(pid, "?") : this.configurationAdmin.getConfiguration(pid, "?");
        return newConfiguration;
    }

    Configuration findExistingConfiguration(String fileName) throws Exception {
        String filter = "(felix.fileinstall.filename=" + this.escapeFilterValue(fileName) + ")";
        Configuration[] configurations = this.configurationAdmin.listConfigurations(filter);
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    private String escapeFilterValue(String s) {
        return s.replaceAll("[(]", "\\\\(").replaceAll("[)]", "\\\\)").replaceAll("[=]", "\\\\=").replaceAll("[\\*]", "\\\\*");
    }
}

