/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;

public class JdkHandler
extends Handler {
    private static final String FQCN = Logger.class.getName();
    private PaxLoggingManager m_loggingManager;

    public JdkHandler(PaxLoggingManager loggingManager) {
        this.m_loggingManager = loggingManager;
        this.setFormatter(new SimpleFormatter());
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        String message;
        Level level = record.getLevel();
        String loggerName = record.getLoggerName();
        PaxLogger logger = this.m_loggingManager.getLogger(loggerName, FQCN);
        try {
            message = this.getFormatter().formatMessage(record);
        }
        catch (Exception ex) {
            message = record.getMessage();
        }
        Throwable throwable = record.getThrown();
        int levelInt = level.intValue();
        if (throwable != null) {
            if (levelInt <= Level.FINER.intValue()) {
                logger.trace(message, (Object)throwable);
            } else if (levelInt <= Level.FINE.intValue()) {
                logger.debug(message, (Object)throwable);
            } else if (levelInt <= Level.INFO.intValue()) {
                logger.info(message, (Object)throwable);
            } else if (levelInt <= Level.WARNING.intValue()) {
                logger.warn(message, (Object)throwable);
            } else {
                logger.error(message, (Object)throwable);
            }
        } else if (levelInt <= Level.FINER.intValue()) {
            logger.trace(message);
        } else if (levelInt <= Level.FINE.intValue()) {
            logger.debug(message);
        } else if (levelInt <= Level.INFO.intValue()) {
            logger.info(message);
        } else if (levelInt <= Level.WARNING.intValue()) {
            logger.warn(message);
        } else {
            logger.error(message);
        }
    }
}

