/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management;

import com.sun.jdmk.security.sasl.AuthenticateCallback;
import java.io.IOException;
import java.rmi.server.RemoteServer;
import java.security.Principal;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import org.apache.karaf.jaas.boot.principal.ClientPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;

public class JaasAuthenticator
implements JMXAuthenticator,
CallbackHandler {
    private String realm;

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    @Override
    public Subject authenticate(Object credentials) throws SecurityException {
        if (!(credentials instanceof String[])) {
            throw new IllegalArgumentException("Expected String[2], got " + (credentials != null ? credentials.getClass().getName() : null));
        }
        String[] params = (String[])credentials;
        if (params.length != 2) {
            throw new IllegalArgumentException("Expected String[2] but length was " + params.length);
        }
        try {
            Subject subject = new Subject();
            try {
                subject.getPrincipals().add((Principal)new ClientPrincipal("jmx", RemoteServer.getClientHost()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LoginContext loginContext = new LoginContext(this.realm, subject, callbacks -> {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(params[0]);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(params[1].toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            });
            loginContext.login();
            int roleCount = 0;
            for (Principal principal : subject.getPrincipals()) {
                if (!(principal instanceof RolePrincipal)) continue;
                ++roleCount;
            }
            if (roleCount == 0) {
                throw new FailedLoginException("User doesn't have role defined");
            }
            return subject;
        }
        catch (LoginException e) {
            throw new SecurityException("Authentication failed", e);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Object acb;
            if (callbacks[i] instanceof AuthenticateCallback) {
                acb = (AuthenticateCallback)callbacks[i];
                Subject subject = new Subject();
                try {
                    subject.getPrincipals().add((Principal)new ClientPrincipal("jmx", RemoteServer.getClientHost()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    LoginContext loginContext = new LoginContext(this.realm, subject, arg_0 -> JaasAuthenticator.lambda$handle$1((AuthenticateCallback)acb, arg_0));
                    loginContext.login();
                }
                catch (Exception e) {
                    throw new SecurityException("Authentication failed", e);
                }
                int roleCount = 0;
                for (Principal principal : subject.getPrincipals()) {
                    if (!(principal instanceof RolePrincipal)) continue;
                    ++roleCount;
                }
                if (roleCount == 0) {
                    throw new SecurityException("User doesn't have role defined");
                }
                acb.setAuthenticated(true);
                continue;
            }
            if (callbacks[i] instanceof AuthorizeCallback) {
                acb = (AuthorizeCallback)callbacks[i];
                ((AuthorizeCallback)acb).setAuthorized(true);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    private static /* synthetic */ void lambda$handle$1(AuthenticateCallback acb, Callback[] cb) throws IOException, UnsupportedCallbackException {
        for (Callback callback : cb) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(acb.getAuthenticationID());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(acb.getPassword());
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

