/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Console;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.karaf.client.ClientConfig;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.agent.local.LocalAgentFactory;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.channel.PtyCapableChannelSession;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.io.NoCloseOutputStream;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.impl.SimpleLogger;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        BufferedReader reader;
        StringBuilder sb;
        ClientConfig config = new ClientConfig(args);
        SimpleLogger.setLevel(config.getLevel());
        if (config.getFile() != null) {
            sb = new StringBuilder();
            sb.setLength(0);
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(config.getFile())));
            Throwable throwable = null;
            try {
                int c = ((Reader)reader).read();
                while (c >= 0) {
                    sb.append((char)c);
                    c = ((Reader)reader).read();
                }
            }
            catch (Throwable c) {
                throwable = c;
                throw c;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable c) {
                            throwable.addSuppressed(c);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                }
            }
            config.setCommand(sb.toString());
        } else if (config.isBatch()) {
            sb = new StringBuilder();
            sb.setLength(0);
            reader = new BufferedReader(new InputStreamReader(System.in));
            int c = ((Reader)reader).read();
            while (c >= 0) {
                sb.append((char)c);
                c = ((Reader)reader).read();
            }
            config.setCommand(sb.toString());
        }
        try (SshClient client = (SshClient)ClientBuilder.builder().build();){
            int exitStatus;
            block65: {
                FilePasswordProvider passwordProvider = null;
                final Console console = System.console();
                if (console != null) {
                    passwordProvider = resourceKey -> {
                        char[] pwd = console.readPassword("Enter password for " + resourceKey + ": ", new Object[0]);
                        return new String(pwd);
                    };
                    client.setFilePasswordProvider(passwordProvider);
                    client.setUserInteraction(new UserInteraction(){

                        public void welcome(ClientSession s, String banner, String lang) {
                            System.out.println(banner);
                        }

                        public String[] interactive(ClientSession s, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
                            String[] answers = new String[prompt.length];
                            try {
                                for (int i = 0; i < prompt.length; ++i) {
                                    answers[i] = echo[i] ? console.readLine(prompt[i] + " ", new Object[0]) : new String(console.readPassword(prompt[i] + " ", new Object[0]));
                                    if (answers[i] != null) continue;
                                    return null;
                                }
                                return answers;
                            }
                            catch (IOError e) {
                                return null;
                            }
                        }

                        public boolean isInteractionAllowed(ClientSession session) {
                            return true;
                        }

                        public void serverVersionInfo(ClientSession session, List<String> lines) {
                        }

                        public String getUpdatedPassword(ClientSession session, String prompt, String lang) {
                            return null;
                        }
                    });
                }
                if (config.getUser() == null || config.getUser().isEmpty()) {
                    String user;
                    while ((user = console.readLine("Enter user: ", new Object[0])) == null || user.isEmpty()) {
                        System.err.println("User must not be empty!");
                    }
                    config.setUser(user);
                } else if (console != null) {
                    console.printf("Logging in as %s\n", config.getUser());
                }
                Main.setupAgent(config.getUser(), config.getKeyFile(), client, passwordProvider);
                client.getProperties().put("heartbeat-interval", "60000");
                client.getProperties().put("idle-timeout", String.valueOf(config.getIdleTimeout()));
                client.getProperties().put("nio2-read-timeout", String.valueOf(config.getIdleTimeout()));
                client.setKeyPairProvider((KeyPairProvider)new FileKeyPairProvider());
                client.start();
                ClientSession session = Main.connectWithRetries(client, config);
                if (config.getPassword() != null) {
                    session.addPasswordIdentity(config.getPassword());
                }
                session.auth().verify();
                exitStatus = 0;
                String type = System.getProperty("org.jline.terminal.type");
                if (type == null) {
                    type = System.getenv("TERM");
                }
                if (type == null) {
                    type = "dumb";
                }
                try (Terminal terminal = TerminalBuilder.builder().nativeSignals(true).type(type).signalHandler(Terminal.SignalHandler.SIG_IGN).build();){
                    ChannelShell channel;
                    if (config.getCommand().length() > 0) {
                        channel = session.createExecChannel(config.getCommand() + "\n");
                        channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
                        if (!config.isBatch()) {
                            new Thread(() -> Main.lambda$main$1((ChannelExec)channel)).start();
                        }
                        channel.setAgentForwarding(true);
                        NoCloseOutputStream output = new NoCloseOutputStream(terminal.output());
                        channel.setOut((OutputStream)output);
                        channel.setErr((OutputStream)output);
                        channel.open().verify();
                        channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), 0L);
                        if (channel.getExitStatus() != null) {
                            exitStatus = channel.getExitStatus();
                        }
                        break block65;
                    }
                    channel = session.createShellChannel();
                    Attributes attributes = terminal.enterRawMode();
                    try {
                        HashMap<PtyMode, Integer> modes = new HashMap<PtyMode, Integer>();
                        modes.put(PtyMode.VINTR, attributes.getControlChar(Attributes.ControlChar.VINTR));
                        modes.put(PtyMode.VQUIT, attributes.getControlChar(Attributes.ControlChar.VQUIT));
                        modes.put(PtyMode.VERASE, attributes.getControlChar(Attributes.ControlChar.VERASE));
                        modes.put(PtyMode.VKILL, attributes.getControlChar(Attributes.ControlChar.VKILL));
                        modes.put(PtyMode.VEOF, attributes.getControlChar(Attributes.ControlChar.VEOF));
                        modes.put(PtyMode.VEOL, attributes.getControlChar(Attributes.ControlChar.VEOL));
                        modes.put(PtyMode.VEOL2, attributes.getControlChar(Attributes.ControlChar.VEOL2));
                        modes.put(PtyMode.VSTART, attributes.getControlChar(Attributes.ControlChar.VSTART));
                        modes.put(PtyMode.VSTOP, attributes.getControlChar(Attributes.ControlChar.VSTOP));
                        modes.put(PtyMode.VSUSP, attributes.getControlChar(Attributes.ControlChar.VSUSP));
                        modes.put(PtyMode.VDSUSP, attributes.getControlChar(Attributes.ControlChar.VDSUSP));
                        modes.put(PtyMode.VREPRINT, attributes.getControlChar(Attributes.ControlChar.VREPRINT));
                        modes.put(PtyMode.VWERASE, attributes.getControlChar(Attributes.ControlChar.VWERASE));
                        modes.put(PtyMode.VLNEXT, attributes.getControlChar(Attributes.ControlChar.VLNEXT));
                        modes.put(PtyMode.VSTATUS, attributes.getControlChar(Attributes.ControlChar.VSTATUS));
                        modes.put(PtyMode.VDISCARD, attributes.getControlChar(Attributes.ControlChar.VDISCARD));
                        modes.put(PtyMode.IGNPAR, Main.getFlag(attributes, Attributes.InputFlag.IGNPAR));
                        modes.put(PtyMode.PARMRK, Main.getFlag(attributes, Attributes.InputFlag.PARMRK));
                        modes.put(PtyMode.INPCK, Main.getFlag(attributes, Attributes.InputFlag.INPCK));
                        modes.put(PtyMode.ISTRIP, Main.getFlag(attributes, Attributes.InputFlag.ISTRIP));
                        modes.put(PtyMode.INLCR, Main.getFlag(attributes, Attributes.InputFlag.INLCR));
                        modes.put(PtyMode.IGNCR, Main.getFlag(attributes, Attributes.InputFlag.IGNCR));
                        modes.put(PtyMode.ICRNL, Main.getFlag(attributes, Attributes.InputFlag.ICRNL));
                        modes.put(PtyMode.IXON, Main.getFlag(attributes, Attributes.InputFlag.IXON));
                        modes.put(PtyMode.IXANY, Main.getFlag(attributes, Attributes.InputFlag.IXANY));
                        modes.put(PtyMode.IXOFF, Main.getFlag(attributes, Attributes.InputFlag.IXOFF));
                        modes.put(PtyMode.ISIG, Main.getFlag(attributes, Attributes.LocalFlag.ISIG));
                        modes.put(PtyMode.ICANON, Main.getFlag(attributes, Attributes.LocalFlag.ICANON));
                        modes.put(PtyMode.ECHO, Main.getFlag(attributes, Attributes.LocalFlag.ECHO));
                        modes.put(PtyMode.ECHOE, Main.getFlag(attributes, Attributes.LocalFlag.ECHOE));
                        modes.put(PtyMode.ECHOK, Main.getFlag(attributes, Attributes.LocalFlag.ECHOK));
                        modes.put(PtyMode.ECHONL, Main.getFlag(attributes, Attributes.LocalFlag.ECHONL));
                        modes.put(PtyMode.NOFLSH, Main.getFlag(attributes, Attributes.LocalFlag.NOFLSH));
                        modes.put(PtyMode.TOSTOP, Main.getFlag(attributes, Attributes.LocalFlag.TOSTOP));
                        modes.put(PtyMode.IEXTEN, Main.getFlag(attributes, Attributes.LocalFlag.IEXTEN));
                        modes.put(PtyMode.OPOST, Main.getFlag(attributes, Attributes.OutputFlag.OPOST));
                        modes.put(PtyMode.ONLCR, Main.getFlag(attributes, Attributes.OutputFlag.ONLCR));
                        modes.put(PtyMode.OCRNL, Main.getFlag(attributes, Attributes.OutputFlag.OCRNL));
                        modes.put(PtyMode.ONOCR, Main.getFlag(attributes, Attributes.OutputFlag.ONOCR));
                        modes.put(PtyMode.ONLRET, Main.getFlag(attributes, Attributes.OutputFlag.ONLRET));
                        channel.setPtyModes(modes);
                        channel.setPtyColumns(terminal.getWidth());
                        channel.setPtyLines(terminal.getHeight());
                        channel.setAgentForwarding(true);
                        channel.setEnv("TERM", terminal.getType());
                        String ctype = System.getenv("LC_CTYPE");
                        if (ctype == null) {
                            ctype = Locale.getDefault().toString() + "." + System.getProperty("input.encoding", Charset.defaultCharset().name());
                        }
                        channel.setEnv("LC_CTYPE", ctype);
                        channel.setIn((InputStream)new NoCloseInputStream(terminal.input()));
                        channel.setOut((OutputStream)new NoCloseOutputStream(terminal.output()));
                        channel.setErr((OutputStream)new NoCloseOutputStream(terminal.output()));
                        channel.open().verify();
                        Terminal.SignalHandler prevWinchHandler = terminal.handle(Terminal.Signal.WINCH, signal -> {
                            try {
                                Size size = terminal.getSize();
                                channel.sendWindowChange(size.getColumns(), size.getRows());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                        Terminal.SignalHandler prevQuitHandler = terminal.handle(Terminal.Signal.QUIT, signal -> {
                            try {
                                channel.getInvertedIn().write(attributes.getControlChar(Attributes.ControlChar.VQUIT));
                                channel.getInvertedIn().flush();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                        Terminal.SignalHandler prevIntHandler = terminal.handle(Terminal.Signal.INT, signal -> {
                            try {
                                channel.getInvertedIn().write(attributes.getControlChar(Attributes.ControlChar.VINTR));
                                channel.getInvertedIn().flush();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                        Terminal.SignalHandler prevStopHandler = terminal.handle(Terminal.Signal.TSTP, signal -> {
                            try {
                                channel.getInvertedIn().write(attributes.getControlChar(Attributes.ControlChar.VDSUSP));
                                channel.getInvertedIn().flush();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                        try {
                            channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), 0L);
                        }
                        finally {
                            terminal.handle(Terminal.Signal.WINCH, prevWinchHandler);
                            terminal.handle(Terminal.Signal.INT, prevIntHandler);
                            terminal.handle(Terminal.Signal.TSTP, prevStopHandler);
                            terminal.handle(Terminal.Signal.QUIT, prevQuitHandler);
                        }
                        if (channel.getExitStatus() != null) {
                            exitStatus = channel.getExitStatus();
                        }
                    }
                    finally {
                        terminal.setAttributes(attributes);
                    }
                }
            }
            System.exit(exitStatus);
        }
        catch (Throwable t) {
            if (config.getLevel() > 1) {
                t.printStackTrace();
            } else {
                System.err.println(t.getMessage());
            }
            System.exit(1);
        }
    }

    private static int getFlag(Attributes attributes, Attributes.InputFlag flag) {
        return attributes.getInputFlag(flag) ? 1 : 0;
    }

    private static int getFlag(Attributes attributes, Attributes.OutputFlag flag) {
        return attributes.getOutputFlag(flag) ? 1 : 0;
    }

    private static int getFlag(Attributes attributes, Attributes.LocalFlag flag) {
        return attributes.getLocalFlag(flag) ? 1 : 0;
    }

    private static void setupAgent(String user, String keyFile, SshClient client, FilePasswordProvider passwordProvider) {
        SshAgent agent = Main.startAgent(user, keyFile, passwordProvider);
        client.setAgentFactory((SshAgentFactory)new LocalAgentFactory(agent));
        client.getProperties().put("SSH_AUTH_SOCK", "local");
    }

    private static ClientSession connectWithRetries(SshClient client, ClientConfig config) throws Exception {
        ClientSession session = null;
        int retries = 0;
        do {
            ConnectFuture future = client.connect(config.getUser(), config.getHost(), config.getPort());
            future.await();
            try {
                session = future.getSession();
            }
            catch (RuntimeSshException ex) {
                if (retries++ < config.getRetryAttempts()) {
                    Thread.sleep((long)config.getRetryDelay() * 1000L);
                    System.out.println("retrying (attempt " + retries + ") ...");
                    continue;
                }
                throw ex;
            }
        } while (session == null);
        return session;
    }

    private static SshAgent startAgent(String user, String keyFile, FilePasswordProvider passwordProvider) {
        try {
            AgentImpl agent = new AgentImpl();
            if (keyFile != null) {
                FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider(Paths.get(keyFile, new String[0]));
                fileKeyPairProvider.setPasswordFinder(passwordProvider);
                for (KeyPair key : fileKeyPairProvider.loadKeys()) {
                    agent.addIdentity(key, user);
                }
            }
            return agent;
        }
        catch (Throwable e) {
            System.err.println("Error starting ssh agent for: " + e.getMessage());
            return null;
        }
    }

    private static void registerSignalHandler(Terminal terminal, PtyCapableChannelSession channel) {
        try {
            Class<?> signalClass = Class.forName("sun.misc.Signal");
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            Object signalHandler = Proxy.newProxyInstance(Main.class.getClassLoader(), new Class[]{signalHandlerClass}, (proxy, method, args) -> {
                Size size = terminal.getSize();
                channel.sendWindowChange(size.getColumns(), size.getRows());
                return null;
            });
            signalClass.getMethod("handle", signalClass, signalHandlerClass).invoke(null, signalClass.getConstructor(String.class).newInstance("WINCH"), signalHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void unregisterSignalHandler() {
        try {
            Class<?> signalClass = Class.forName("sun.misc.Signal");
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            Object signalHandler = signalHandlerClass.getField("SIG_DFL").get(null);
            signalClass.getMethod("handle", signalClass, signalHandlerClass).invoke(null, signalClass.getConstructor(String.class).newInstance("WINCH"), signalHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$main$1(ChannelExec channel) {
        block2: while (true) {
            try {
                while (true) {
                    int a;
                    if ((a = System.in.read()) == -1) {
                        channel.close(true);
                        break block2;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

