/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.repository;

import java.io.File;
import shaded.org.eclipse.aether.repository.ArtifactRepository;

public final class LocalRepository
implements ArtifactRepository {
    private final File basedir;
    private final String type;

    public LocalRepository(String basedir) {
        this(basedir != null ? new File(basedir) : null, "");
    }

    public LocalRepository(File basedir) {
        this(basedir, "");
    }

    public LocalRepository(File basedir, String type) {
        this.basedir = basedir;
        this.type = type != null ? type : "";
    }

    @Override
    public String getContentType() {
        return this.type;
    }

    @Override
    public String getId() {
        return "local";
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String toString() {
        return this.getBasedir() + " (" + this.getContentType() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        LocalRepository that = (LocalRepository)obj;
        return LocalRepository.eq(this.basedir, that.basedir) && LocalRepository.eq(this.type, that.type);
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + LocalRepository.hash(this.basedir);
        hash = hash * 31 + LocalRepository.hash(this.type);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

