/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.core.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.config.core.ConfigMBean;
import org.apache.karaf.config.core.ConfigRepository;
import org.apache.karaf.util.StreamUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;

public class ConfigMBeanImpl
extends StandardMBean
implements ConfigMBean {
    private ConfigRepository configRepo;

    public ConfigMBeanImpl() throws NotCompliantMBeanException {
        super(ConfigMBean.class);
    }

    private Configuration getConfiguration(String pid) throws IOException {
        Configuration configuration = this.configRepo.getConfigAdmin().getConfiguration(pid, null);
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration PID " + pid + " doesn't exist");
        }
        return configuration;
    }

    private TypedProperties getConfigProperties(String pid) throws IOException, InvalidSyntaxException {
        return this.configRepo.getConfig(pid);
    }

    @Override
    public List<String> getConfigs() throws MBeanException {
        try {
            return Arrays.stream(this.configRepo.getConfigAdmin().listConfigurations(null)).map(Configuration::getPid).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void create(String pid) throws MBeanException {
        try {
            this.configRepo.update(pid, new TypedProperties());
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void install(String url, String finalname, boolean override) throws MBeanException {
        if (finalname.contains("..")) {
            throw new IllegalArgumentException("For security reason, relative path is not allowed in config file final name");
        }
        try {
            File etcFolder = new File(System.getProperty("karaf.etc"));
            File file = new File(etcFolder, finalname);
            if (file.exists() && !override) {
                throw new IllegalArgumentException("Configuration file {} already exists " + finalname);
            }
            try (BufferedInputStream is = new BufferedInputStream(new URL(url).openStream());){
                if (!file.exists()) {
                    File parentFile = file.getParentFile();
                    if (parentFile != null) {
                        parentFile.mkdirs();
                    }
                    file.createNewFile();
                }
                try (FileOutputStream fop = new FileOutputStream(file);){
                    StreamUtils.copy(is, fop);
                }
            }
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void delete(String pid) throws MBeanException {
        try {
            this.configRepo.delete(pid);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public Map<String, String> listProperties(String pid) throws MBeanException {
        try {
            TypedProperties dictionary = this.getConfigProperties(pid);
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            for (Map.Entry<String, Object> e : dictionary.entrySet()) {
                propertiesMap.put(e.getKey(), this.displayValue(e.getValue().toString()));
            }
            return propertiesMap;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    protected String displayValue(Object value) {
        if (value == null) {
            return "<null>";
        }
        if (value.getClass().isArray()) {
            return Arrays.toString((Object[])value);
        }
        return value.toString();
    }

    @Override
    public void deleteProperty(String pid, String key) throws MBeanException {
        try {
            TypedProperties dictionary = this.getConfigProperties(pid);
            dictionary.remove(key);
            this.configRepo.update(pid, dictionary);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void appendProperty(String pid, String key, String value) throws MBeanException {
        try {
            TypedProperties dictionary = this.getConfigProperties(pid);
            Object currentValue = dictionary.get(key);
            if (currentValue == null) {
                dictionary.put(key, (Object)value);
            } else if (currentValue instanceof String) {
                dictionary.put(key, (Object)(currentValue + value));
            } else {
                throw new IllegalStateException("Current value is not a String");
            }
            this.configRepo.update(pid, dictionary);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void setProperty(String pid, String key, String value) throws MBeanException {
        try {
            TypedProperties dictionary = this.getConfigProperties(pid);
            dictionary.put(key, (Object)value);
            this.configRepo.update(pid, dictionary);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public String getProperty(String pid, String key) throws MBeanException {
        try {
            TypedProperties dictionary = this.getConfigProperties(pid);
            Object value = dictionary.get(key);
            if (value != null) {
                return value.toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void update(String pid, Map<String, String> properties) throws MBeanException {
        try {
            TypedProperties props = this.configRepo.getConfig(pid);
            props.putAll(properties);
            this.configRepo.update(pid, props);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    private Dictionary<String, Object> toDictionary(Map<String, String> properties) {
        Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
        for (String key : properties.keySet()) {
            ((Dictionary)dictionary).put(key, properties.get(key));
        }
        return dictionary;
    }

    public void setConfigRepo(ConfigRepository configRepo) {
        this.configRepo = configRepo;
    }

    @Override
    public String createFactoryConfiguration(String factoryPid, Map<String, String> properties) throws MBeanException {
        try {
            TypedProperties props = new TypedProperties();
            props.putAll(properties);
            return this.configRepo.createFactoryConfiguration(factoryPid, props);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }
}

