/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.features.ConfigFileInfo;
import org.apache.karaf.features.ConfigInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.service.FeaturesServiceImpl;
import org.apache.karaf.util.StreamUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureConfigInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesServiceImpl.class);
    private static final String CONFIG_KEY = "org.apache.karaf.features.configKey";
    private static final String FILEINSTALL_FILE_NAME = "felix.fileinstall.filename";
    private final ConfigurationAdmin configAdmin;
    private File storage;
    private boolean configCfgStore;

    public FeatureConfigInstaller(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
        this.storage = new File(System.getProperty("karaf.etc"));
        this.configCfgStore = true;
    }

    public FeatureConfigInstaller(ConfigurationAdmin configAdmin, boolean configCfgStore) {
        this.configAdmin = configAdmin;
        this.storage = new File(System.getProperty("karaf.etc"));
        this.configCfgStore = configCfgStore;
    }

    private ConfigId parsePid(String pid) {
        int n = pid.indexOf(45);
        ConfigId cid = new ConfigId();
        cid.fullPid = pid;
        if (n > 0) {
            cid.factoryPid = pid.substring(n + 1);
            cid.pid = pid.substring(0, n);
        } else {
            cid.pid = pid;
        }
        return cid;
    }

    private Configuration createConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        if (factoryPid != null) {
            return configurationAdmin.createFactoryConfiguration(pid, null);
        }
        return configurationAdmin.getConfiguration(pid, null);
    }

    private Configuration findExistingConfiguration(ConfigurationAdmin configurationAdmin, ConfigId cid) throws IOException, InvalidSyntaxException {
        String filter = cid.factoryPid == null ? "(service.pid=" + cid.pid + ")" : "(org.apache.karaf.features.configKey=" + cid.fullPid + ")";
        Configuration[] configurations = configurationAdmin.listConfigurations(filter);
        return configurations != null && configurations.length > 0 ? configurations[0] : null;
    }

    public void installFeatureConfigs(Feature feature) throws IOException, InvalidSyntaxException {
        for (ConfigInfo config : feature.getConfigurations()) {
            TypedProperties props = new TypedProperties();
            String val = config.getValue();
            if (config.isExternal()) {
                props.load(new URL(val));
            } else {
                props.load(new StringReader(val));
            }
            ConfigId cid = this.parsePid(config.getName());
            Configuration cfg = this.findExistingConfiguration(this.configAdmin, cid);
            if (cfg == null) {
                File cfgFile = null;
                if (this.storage != null) {
                    cfgFile = new File(this.storage, cid.fullPid + ".cfg");
                }
                if (!cfgFile.exists()) {
                    Dictionary<String, Object> cfgProps = this.convertToDict(props);
                    cfg = this.createConfiguration(this.configAdmin, cid.pid, cid.factoryPid);
                    cfgProps.put(CONFIG_KEY, cid.fullPid);
                    props.put(CONFIG_KEY, (Object)cid.fullPid);
                    if (this.storage != null && this.configCfgStore) {
                        cfgProps.put(FILEINSTALL_FILE_NAME, cfgFile.getAbsoluteFile().toURI().toString());
                    }
                    cfg.update(cfgProps);
                    try {
                        this.updateStorage(cid, props, false);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Can't update cfg file", (Throwable)e);
                    }
                    continue;
                }
                LOGGER.info("Skipping configuration {} - file already exists", (Object)cfgFile);
                continue;
            }
            if (!config.isAppend()) continue;
            boolean update = false;
            Dictionary properties = cfg.getProperties();
            for (String key : props.keySet()) {
                if (properties.get(key) != null) continue;
                properties.put(key, props.get(key));
                update = true;
            }
            if (!update) continue;
            cfg.update(properties);
            try {
                this.updateStorage(cid, props, true);
            }
            catch (Exception e) {
                LOGGER.warn("Can't update cfg file", (Throwable)e);
            }
        }
        for (ConfigFileInfo configFile : feature.getConfigurationFiles()) {
            this.installConfigurationFile(configFile.getLocation(), configFile.getFinalname(), configFile.isOverride());
        }
    }

    private Dictionary<String, Object> convertToDict(Map<String, Object> props) {
        Hashtable<String, Object> cfgProps = new Hashtable<String, Object>();
        for (Map.Entry<String, Object> e : props.entrySet()) {
            ((Dictionary)cfgProps).put(e.getKey(), e.getValue());
        }
        return cfgProps;
    }

    protected static String substFinalName(String finalname) {
        String markerVarBeg = "${";
        String markerVarEnd = "}";
        boolean startsWithVariable = finalname.startsWith("${") && finalname.contains("}");
        String dummyKey = "";
        try {
            finalname = InterpolationHelper.substVars(finalname, "", null, null, null, true, true, false);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.info("Substitution failed. Skip substitution of variables of configuration final name ({}).", (Object)finalname);
        }
        if (!startsWithVariable || finalname.startsWith("${")) {
            String basePath = System.getProperty("karaf.base");
            finalname = basePath + File.separator + finalname;
        }
        while (finalname.contains("${") && finalname.contains("}")) {
            int beg = finalname.indexOf("${");
            int end = finalname.indexOf("}");
            String rem = finalname.substring(beg, end + "}".length());
            finalname = finalname.replace(rem, "");
        }
        return finalname;
    }

    private void installConfigurationFile(String fileLocation, String finalname, boolean override) throws IOException {
        File file = new File(finalname = FeatureConfigInstaller.substFinalName(finalname));
        if (file.exists()) {
            if (!override) {
                LOGGER.debug("Configuration file {} already exist, don't override it", (Object)finalname);
                return;
            }
            LOGGER.info("Configuration file {} already exist, overriding it", (Object)finalname);
        } else {
            LOGGER.info("Creating configuration file {}", (Object)finalname);
        }
        try (BufferedInputStream is = new BufferedInputStream(new URL(fileLocation).openStream());){
            if (!file.exists()) {
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                file.createNewFile();
            }
            try (FileOutputStream fop = new FileOutputStream(file);){
                StreamUtils.copy(is, fop);
            }
        }
        catch (RuntimeException | MalformedURLException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
    }

    protected void updateStorage(ConfigId cid, TypedProperties props, boolean append) throws Exception {
        if (this.storage != null && this.configCfgStore) {
            File cfgFile = this.getConfigFile(cid);
            if (!cfgFile.exists()) {
                props.save(cfgFile);
            } else {
                this.updateExistingConfig(props, append, cfgFile);
            }
        }
    }

    private File getConfigFile(ConfigId cid) throws IOException, InvalidSyntaxException {
        Configuration cfg = this.findExistingConfiguration(this.configAdmin, cid);
        File cfgFile = new File(this.storage, cid.fullPid + ".cfg");
        if (cfg != null && cfg.getProperties() != null) {
            Object val = cfg.getProperties().get(FILEINSTALL_FILE_NAME);
            try {
                if (val instanceof URL) {
                    cfgFile = new File(((URL)val).toURI());
                }
                if (val instanceof URI) {
                    cfgFile = new File((URI)val);
                }
                if (val instanceof String) {
                    cfgFile = new File(new URL((String)val).toURI());
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        LOGGER.trace("Update {}", (Object)cfgFile.getName());
        return cfgFile;
    }

    private void updateExistingConfig(TypedProperties props, boolean append, File cfgFile) throws IOException {
        TypedProperties properties = new TypedProperties();
        properties.load(cfgFile);
        for (String key : props.keySet()) {
            if (this.isInternalKey(key)) continue;
            List<String> comments = props.getComments(key);
            Object value = props.get(key);
            if (!properties.containsKey(key)) {
                properties.put(key, comments, value);
                continue;
            }
            if (append) continue;
            if (comments.isEmpty()) {
                comments = properties.getComments(key);
            }
            properties.put(key, comments, value);
        }
        if (!append) {
            ArrayList<String> propertiesToRemove = new ArrayList<String>();
            for (String key : properties.keySet()) {
                if (props.containsKey(key) || this.isInternalKey(key)) continue;
                propertiesToRemove.add(key);
            }
            for (String key : propertiesToRemove) {
                properties.remove(key);
            }
        }
        this.storage.mkdirs();
        properties.save(cfgFile);
    }

    private boolean isInternalKey(String key) {
        return "service.pid".equals(key) || "service.factoryPid".equals(key) || FILEINSTALL_FILE_NAME.equals(key);
    }

    class ConfigId {
        String fullPid;
        String pid;
        String factoryPid;

        ConfigId() {
        }
    }
}

