/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.adapter;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.eventadmin.impl.adapter.AbstractAdapter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class BundleEventAdapter
extends AbstractAdapter
implements SynchronousBundleListener {
    public BundleEventAdapter(BundleContext context, EventAdmin admin) {
        super(admin);
        context.addBundleListener((BundleListener)this);
    }

    @Override
    public void destroy(BundleContext context) {
        context.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("event", event);
        ((Dictionary)properties).put("bundle.id", new Long(event.getBundle().getBundleId()));
        String symbolicName = event.getBundle().getSymbolicName();
        if (null != symbolicName) {
            ((Dictionary)properties).put("bundle.symbolicName", symbolicName);
        }
        ((Dictionary)properties).put("bundle", event.getBundle());
        StringBuffer topic = new StringBuffer(BundleEvent.class.getName().replace('.', '/')).append('/');
        switch (event.getType()) {
            case 1: {
                topic.append("INSTALLED");
                break;
            }
            case 128: {
                topic.append("STARTING");
                break;
            }
            case 2: {
                topic.append("STARTED");
                break;
            }
            case 256: {
                topic.append("STOPPING");
                break;
            }
            case 4: {
                topic.append("STOPPED");
                break;
            }
            case 8: {
                topic.append("UPDATED");
                break;
            }
            case 16: {
                topic.append("UNINSTALLED");
                break;
            }
            case 32: {
                topic.append("RESOLVED");
                break;
            }
            case 64: {
                topic.append("UNRESOLVED");
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.getEventAdmin().postEvent(new Event(topic.toString(), (Dictionary<String, ?>)properties));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

