/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class JSONWriter {
    private final Writer pw;
    private boolean comma = false;

    public JSONWriter(Writer pw) {
        this.pw = pw;
    }

    public JSONWriter object() throws IOException {
        if (this.comma) {
            this.pw.write(44);
        }
        this.pw.write("{");
        this.comma = false;
        return this;
    }

    public JSONWriter endObject() throws IOException {
        this.pw.write(125);
        this.comma = true;
        return this;
    }

    public JSONWriter array() throws IOException {
        if (this.comma) {
            this.pw.write(44);
        }
        this.pw.write("[");
        this.comma = false;
        return this;
    }

    public JSONWriter endArray() throws IOException {
        this.pw.write(93);
        this.comma = true;
        return this;
    }

    public JSONWriter key(String key) throws IOException {
        if (this.comma) {
            this.pw.write(44);
        }
        this.quote(key);
        this.pw.write(58);
        this.comma = false;
        return this;
    }

    public JSONWriter value(boolean b) throws IOException {
        if (this.comma) {
            this.pw.write(44);
        }
        this.pw.write(b ? "true" : "false");
        this.comma = true;
        return this;
    }

    public JSONWriter value(double d) throws IOException {
        return this.value(new Double(d));
    }

    public JSONWriter value(int i) throws IOException {
        if (this.comma) {
            this.pw.write(44);
        }
        this.pw.write(String.valueOf(i));
        this.comma = true;
        return this;
    }

    public JSONWriter value(long l) throws IOException {
        if (this.comma) {
            this.pw.write(44);
        }
        this.pw.write(String.valueOf(l));
        this.comma = true;
        return this;
    }

    public JSONWriter value(Object value) throws IOException {
        if (this.comma) {
            this.pw.write(44);
        }
        if (value == null || value.equals(null)) {
            this.pw.write("null");
        } else if (value instanceof Boolean) {
            this.pw.write(value.toString());
        } else if (value instanceof Number) {
            String str = value.toString();
            if (str.indexOf(46) == -1 || str.indexOf(101) > 0 || str.indexOf(69) > 0) {
                this.pw.write(str);
            } else {
                while (str.endsWith("0")) {
                    str = str.substring(0, str.length() - 1);
                }
                if (str.endsWith(".")) {
                    str = str.substring(0, str.length() - 1);
                }
                this.pw.write(str);
            }
        } else if (value instanceof Map) {
            this.comma = false;
            this.object();
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                this.key((String)entry.getKey());
                this.value(entry.getValue());
            }
            this.endObject();
        } else if (value.getClass().isArray()) {
            this.comma = false;
            this.array();
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object val = Array.get(value, i);
                this.value(val);
            }
            this.endArray();
        } else if (value instanceof Collection) {
            this.comma = false;
            this.array();
            Collection col = (Collection)value;
            Iterator i = col.iterator();
            while (i.hasNext()) {
                this.value(i.next());
            }
            this.endArray();
        } else {
            this.quote(value.toString());
        }
        this.comma = true;
        return this;
    }

    private void quote(String value) throws IOException {
        this.pw.write(34);
        int len = value.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    this.pw.write("\\\"");
                    continue block10;
                }
                case '\\': {
                    this.pw.write("\\\\");
                    continue block10;
                }
                case '\b': {
                    this.pw.write("\\b");
                    continue block10;
                }
                case '\f': {
                    this.pw.write("\\f");
                    continue block10;
                }
                case '\n': {
                    this.pw.write("\\n");
                    continue block10;
                }
                case '\r': {
                    this.pw.write("\\r");
                    continue block10;
                }
                case '\t': {
                    this.pw.write("\\t");
                    continue block10;
                }
                case '/': {
                    this.pw.write("\\/");
                    continue block10;
                }
                default: {
                    if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff') {
                        String hex = Integer.toHexString(c);
                        this.pw.write("\\u");
                        for (int k = 0; k < 4 - hex.length(); ++k) {
                            this.pw.write(48);
                        }
                        this.pw.write(hex.toUpperCase());
                        continue block10;
                    }
                    this.pw.write(c);
                }
            }
        }
        this.pw.write(34);
    }

    public void flush() throws IOException {
        this.pw.flush();
    }
}

