/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class Moduli {
    public static final int MODULI_TYPE_SAFE = 2;
    public static final int MODULI_TESTS_COMPOSITE = 1;

    private Moduli() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static List<DhGroup> parseModuli(URL url) throws IOException {
        ArrayList<DhGroup> groups = new ArrayList<DhGroup>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String line = r.readLine();
            while (line != null) {
                int tries;
                int tests;
                int type;
                String[] parts;
                if (!(line = line.trim()).startsWith("#") && (parts = line.split("\\s+")).length == 7 && (type = Integer.parseInt(parts[1])) == 2 && ((tests = Integer.parseInt(parts[2])) & 1) == 0 && (tests & 0xFFFFFFFE) != 0 && (tries = Integer.parseInt(parts[3])) != 0) {
                    DhGroup group = new DhGroup();
                    group.size = Integer.parseInt(parts[4]) + 1;
                    group.g = new BigInteger(parts[5], 16);
                    group.p = new BigInteger(parts[6], 16);
                    groups.add(group);
                }
                line = r.readLine();
            }
            ArrayList<DhGroup> arrayList = groups;
            return arrayList;
        }
    }

    public static class DhGroup {
        int size;
        BigInteger g;
        BigInteger p;
    }
}

