/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.SimpleFilter;
import org.apache.felix.cm.impl.persistence.ExtPersistenceManager;

public class CachingPersistenceManagerProxy
implements ExtPersistenceManager {
    private final PersistenceManager pm;
    private final Map<String, CaseInsensitiveDictionary> cache = new HashMap<String, CaseInsensitiveDictionary>();
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private volatile boolean fullyLoaded;
    private final Map<String, Set<String>> factoryConfigCache = new HashMap<String, Set<String>>();

    public CachingPersistenceManagerProxy(PersistenceManager pm) {
        this.pm = pm;
    }

    @Override
    public PersistenceManager getDelegatee() {
        return this.pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String pid) throws IOException {
        Lock lock = this.globalLock.writeLock();
        try {
            Set<String> factoryPids;
            String factoryPid;
            lock.lock();
            Dictionary props = this.cache.remove(pid);
            if (props != null && (factoryPid = (String)props.get("service.factoryPid")) != null && (factoryPids = this.factoryConfigCache.get(factoryPid)) != null) {
                factoryPids.remove(pid);
                if (factoryPids.isEmpty()) {
                    this.factoryConfigCache.remove(factoryPid);
                }
            }
            this.pm.delete(pid);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String pid) {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            boolean bl = this.cache.containsKey(pid) || !this.fullyLoaded && this.pm.exists(pid);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Enumeration getDictionaries() throws IOException {
        return Collections.enumeration(this.getDictionaries(null));
    }

    private final CaseInsensitiveDictionary cache(Dictionary props) {
        String pid = (String)props.get("service.pid");
        CaseInsensitiveDictionary dict = null;
        if (pid != null && (dict = this.cache.get(pid)) == null) {
            dict = new CaseInsensitiveDictionary(props);
            this.cache.put(pid, dict);
            String factoryPid = (String)props.get("service.factoryPid");
            if (factoryPid != null) {
                Set<String> factoryPids = this.factoryConfigCache.get(factoryPid);
                if (factoryPids == null) {
                    factoryPids = new HashSet<String>();
                    this.factoryConfigCache.put(factoryPid, factoryPids);
                }
                factoryPids.add(pid);
            }
        }
        return dict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Dictionary> getDictionaries(SimpleFilter filter) throws IOException {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            if (!this.fullyLoaded) {
                lock.unlock();
                lock = this.globalLock.writeLock();
                lock.lock();
                if (!this.fullyLoaded) {
                    Enumeration fromPm = this.pm.getDictionaries();
                    while (fromPm.hasMoreElements()) {
                        Dictionary next = (Dictionary)fromPm.nextElement();
                        this.cache(next);
                    }
                    this.fullyLoaded = true;
                }
            }
            ArrayList<Dictionary> configs = new ArrayList<Dictionary>();
            for (Dictionary dictionary : this.cache.values()) {
                if (dictionary.get("service.pid") == null || filter != null && !filter.matches(dictionary)) continue;
                configs.add(new CaseInsensitiveDictionary(dictionary));
            }
            ArrayList<Dictionary> arrayList = configs;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dictionary load(String pid) throws IOException {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            CaseInsensitiveDictionary loaded = this.cache.get(pid);
            if (loaded == null && !this.fullyLoaded) {
                Dictionary props;
                lock.unlock();
                lock = this.globalLock.writeLock();
                lock.lock();
                loaded = this.cache.get(pid);
                if (loaded == null && (props = this.pm.load(pid)) != null) {
                    loaded = this.cache(props);
                }
            }
            CaseInsensitiveDictionary caseInsensitiveDictionary = loaded == null ? null : new CaseInsensitiveDictionary(loaded);
            return caseInsensitiveDictionary;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String pid, Dictionary properties) throws IOException {
        Lock lock = this.globalLock.writeLock();
        try {
            lock.lock();
            this.pm.store(pid, properties);
            this.cache.remove(pid);
            this.cache(properties);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getFactoryConfigurationPids(List<String> targetedFactoryPids) throws IOException {
        HashSet<String> pids = new HashSet<String>();
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            if (!this.fullyLoaded) {
                lock.unlock();
                lock = this.globalLock.writeLock();
                lock.lock();
                if (!this.fullyLoaded) {
                    Enumeration fromPm = this.pm.getDictionaries();
                    while (fromPm.hasMoreElements()) {
                        Dictionary next = (Dictionary)fromPm.nextElement();
                        this.cache(next);
                    }
                    this.fullyLoaded = true;
                }
                lock.unlock();
                lock = this.globalLock.readLock();
                lock.lock();
            }
            for (String targetFactoryPid : targetedFactoryPids) {
                Set<String> cachedPids = this.factoryConfigCache.get(targetFactoryPid);
                if (cachedPids == null) continue;
                pids.addAll(cachedPids);
            }
        }
        finally {
            lock.unlock();
        }
        return pids;
    }
}

