/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.karaf.config.command.ConfigCommandSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.service.cm.Configuration;

@Command(scope="config", name="list", description="Lists existing configurations.")
@Service
public class ListCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="query", description="Query in LDAP syntax. Example: \"(service.pid=org.apache.karaf.log)\"", required=false, multiValued=false)
    String query;

    @Override
    protected Object doExecute() throws Exception {
        Configuration[] configs = this.configRepository.getConfigAdmin().listConfigurations(this.query);
        if (configs != null) {
            TreeMap<String, Configuration> sortedConfigs = new TreeMap<String, Configuration>();
            for (Configuration config : configs) {
                sortedConfigs.put(config.getPid(), config);
            }
            for (Configuration config : sortedConfigs.values()) {
                System.out.println("----------------------------------------------------------------");
                System.out.println("Pid:            " + config.getPid());
                if (config.getFactoryPid() != null) {
                    System.out.println("FactoryPid:     " + config.getFactoryPid());
                }
                System.out.println("BundleLocation: " + config.getBundleLocation());
                if (config.getProperties() == null) continue;
                System.out.println("Properties:");
                Dictionary props = config.getProperties();
                TreeMap sortedProps = new TreeMap();
                Enumeration e = props.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    sortedProps.put(key.toString(), props.get(key));
                }
                for (Map.Entry entry : sortedProps.entrySet()) {
                    System.out.println("   " + (String)entry.getKey() + " = " + this.displayValue(entry.getValue()));
                }
            }
        }
        return null;
    }
}

