/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.core.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.config.core.ConfigRepository;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRepositoryImpl
implements ConfigRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRepositoryImpl.class);
    private static final String FILEINSTALL_FILE_NAME = "felix.fileinstall.filename";
    private ConfigurationAdmin configAdmin;

    public ConfigRepositoryImpl(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    @Override
    public void update(String pid, Map<String, Object> properties) throws IOException {
        try {
            LOGGER.trace("Updating configuration {}", (Object)pid);
            Configuration cfg = this.configAdmin.getConfiguration(pid, "?");
            Dictionary dict = cfg.getProperties();
            TypedProperties props = new TypedProperties();
            File file = this.getCfgFileFromProperties(dict);
            if (file != null) {
                props.load(file);
                props.putAll(properties);
                props.keySet().retainAll(properties.keySet());
                props.save(file);
                props.clear();
                props.load(file);
                props.put(FILEINSTALL_FILE_NAME, (Object)file.toURI().toString());
            } else {
                file = new File(System.getProperty("karaf.etc"), pid + ".cfg");
                props.putAll(properties);
                props.keySet().retainAll(properties.keySet());
                props.save(file);
                props.put(FILEINSTALL_FILE_NAME, (Object)file.toURI().toString());
            }
            cfg.update(new Hashtable<String, Object>(props));
        }
        catch (URISyntaxException e) {
            throw new IOException("Error updating config", e);
        }
    }

    @Override
    public void delete(String pid) throws Exception {
        LOGGER.trace("Deleting configuration {}", (Object)pid);
        Configuration configuration = this.configAdmin.getConfiguration(pid, null);
        configuration.delete();
    }

    private File getCfgFileFromProperties(Dictionary<String, Object> properties) throws URISyntaxException, MalformedURLException {
        if (properties != null) {
            Object val = properties.get(FILEINSTALL_FILE_NAME);
            return this.getCfgFileFromProperty(val);
        }
        return null;
    }

    private File getCfgFileFromProperty(Object val) throws URISyntaxException, MalformedURLException {
        if (val instanceof URL) {
            return new File(((URL)val).toURI());
        }
        if (val instanceof URI) {
            return new File((URI)val);
        }
        if (val instanceof String) {
            return new File(new URL((String)val).toURI());
        }
        return null;
    }

    @Override
    public TypedProperties getConfig(String pid) throws IOException, InvalidSyntaxException {
        Configuration configuration;
        if (pid != null && this.configAdmin != null && (configuration = this.configAdmin.getConfiguration(pid, null)) != null) {
            TypedProperties tp = new TypedProperties();
            Dictionary props = configuration.getProperties();
            if (props != null) {
                File file;
                try {
                    file = this.getCfgFileFromProperties(props);
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
                if (file != null) {
                    tp.load(file);
                } else {
                    Enumeration e = props.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        Object val = props.get(key);
                        tp.put(key, val);
                    }
                    tp.remove("service.pid");
                    tp.remove("service.factoryPid");
                }
            }
            return tp;
        }
        return null;
    }

    @Override
    public String createFactoryConfiguration(String factoryPid, Map<String, Object> properties) throws IOException {
        return this.createFactoryConfiguration(factoryPid, null, properties);
    }

    @Override
    public String createFactoryConfiguration(String factoryPid, String alias, Map<String, Object> properties) throws IOException {
        Configuration config = this.configAdmin.createFactoryConfiguration(factoryPid, "?");
        TypedProperties props = new TypedProperties();
        File file = File.createTempFile(factoryPid + "-", ".cfg", new File(System.getProperty("karaf.etc")));
        props.putAll(properties);
        props.save(file);
        props.put(FILEINSTALL_FILE_NAME, (Object)file.toURI().toString());
        config.update(new Hashtable<String, Object>(props));
        return config.getPid();
    }

    @Override
    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }
}

