/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.karaf.features.internal.repository.BaseRepository;
import org.apache.karaf.features.internal.repository.UrlLoader;
import org.apache.karaf.features.internal.resolver.ResourceBuilder;
import org.apache.karaf.features.internal.resolver.ResourceImpl;
import org.apache.karaf.util.json.JsonReader;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRepository
extends BaseRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonRepository.class);
    private final boolean ignoreFailures;
    private final UrlLoader loader;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public JsonRepository(String url, long expiration, boolean ignoreFailures) {
        this.loader = new UrlLoader(url, expiration){

            @Override
            protected boolean doRead(InputStream is) throws IOException {
                return JsonRepository.this.doRead(is);
            }
        };
        this.ignoreFailures = ignoreFailures;
    }

    @Override
    public List<Resource> getResources() {
        this.checkAndLoadCache();
        this.lock.readLock().lock();
        try {
            List<Resource> list = super.getResources();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        this.checkAndLoadCache();
        this.lock.readLock().lock();
        try {
            Map<Requirement, Collection<Capability>> map = super.findProviders(requirements);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void checkAndLoadCache() {
        try {
            this.loader.checkAndLoadCache();
        }
        catch (Exception e) {
            if (this.ignoreFailures) {
                this.logger.warn("Ignoring failure: " + e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRead(InputStream is) throws IOException {
        Map<String, Map<String, String>> metadatas = this.verify(JsonReader.read(is));
        this.lock.writeLock().lock();
        try {
            this.resources.clear();
            this.capSets.clear();
            for (Map.Entry<String, Map<String, String>> metadata : metadatas.entrySet()) {
                try {
                    ResourceImpl resource = ResourceBuilder.build(metadata.getKey(), metadata.getValue());
                    this.addResource(resource);
                }
                catch (Exception e) {
                    LOGGER.info("Unable to build resource for " + metadata.getKey(), (Throwable)e);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private Map<String, Map<String, String>> verify(Object value) {
        Map obj = (Map)Map.class.cast(value);
        for (Map.Entry entry : obj.entrySet()) {
            String.class.cast(entry.getKey());
            Map child = (Map)Map.class.cast(entry.getValue());
            for (Map.Entry ce : child.entrySet()) {
                String.class.cast(ce.getKey());
                String.class.cast(ce.getValue());
            }
        }
        return obj;
    }
}

