/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.region;

import java.io.BufferedReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.ResolverImpl;
import org.apache.karaf.features.internal.region.CandidateComparator;
import org.apache.karaf.features.internal.repository.BaseRepository;
import org.apache.karaf.features.internal.resolver.RequirementImpl;
import org.apache.karaf.features.internal.resolver.ResourceBuilder;
import org.apache.karaf.features.internal.resolver.ResourceImpl;
import org.apache.karaf.features.internal.resolver.SimpleFilter;
import org.apache.karaf.util.json.JsonReader;
import org.osgi.framework.BundleException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;
import org.osgi.service.repository.Repository;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolveContext;

public class OfflineResolver {
    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 1) {
            throw new IllegalArgumentException("File path expected");
        }
        OfflineResolver.resolve(args[0]);
    }

    public static void resolve(String resolutionFile) throws Exception {
        Map resolution;
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(resolutionFile, new String[0]), StandardCharsets.UTF_8);){
            resolution = (Map)JsonReader.read(reader);
        }
        final Repository globalRepository = resolution.containsKey("globalRepository") ? OfflineResolver.readRepository(resolution.get("globalRepository")) : null;
        final Repository repository = OfflineResolver.readRepository(resolution.get("repository"));
        ResolverImpl resolver = new ResolverImpl(new Logger(1));
        Map wiring = resolver.resolve(new ResolveContext(){
            private final CandidateComparator candidateComparator = new CandidateComparator(r -> 0);

            public Collection<Resource> getMandatoryResources() {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                RequirementImpl req = new RequirementImpl(null, "osgi.identity", Collections.emptyMap(), Collections.emptyMap(), SimpleFilter.parse("(osgi.identity=root)"));
                Collection<Capability> identities = repository.findProviders(Collections.singleton(req)).get(req);
                for (Capability identity : identities) {
                    resources.add(identity.getResource());
                }
                return resources;
            }

            public List<Capability> findProviders(Requirement requirement) {
                Collection<Capability> res;
                ArrayList<Capability> caps = new ArrayList<Capability>();
                Map<Requirement, Collection<Capability>> resMap = repository.findProviders(Collections.singleton(requirement));
                Collection<Capability> collection = res = resMap != null ? resMap.get(requirement) : null;
                if (res != null && !res.isEmpty()) {
                    caps.addAll(res);
                } else if (globalRepository != null && !"optional".equals(requirement.getDirectives().get("resolution"))) {
                    resMap = globalRepository.findProviders(Collections.singleton(requirement));
                    Collection<Capability> collection2 = res = resMap != null ? resMap.get(requirement) : null;
                    if (res != null && !res.isEmpty()) {
                        caps.addAll(res);
                    }
                }
                Collections.sort(caps, this.candidateComparator);
                return caps;
            }

            public int insertHostedCapability(List<Capability> capabilities, HostedCapability hostedCapability) {
                int idx = Collections.binarySearch(capabilities, hostedCapability, this.candidateComparator);
                if (idx < 0) {
                    idx = Math.abs(idx + 1);
                }
                capabilities.add(idx, (Capability)hostedCapability);
                return idx;
            }

            public boolean isEffective(Requirement requirement) {
                return true;
            }

            public Map<Resource, Wiring> getWirings() {
                return Collections.emptyMap();
            }
        });
    }

    private static Repository readRepository(Object repository) throws BundleException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Collection metadatas = repository instanceof Map ? ((Map)repository).values() : (Collection)repository;
        for (Map metadata : metadatas) {
            ResourceImpl res = new ResourceImpl();
            for (String cap : (List)metadata.get("capabilities")) {
                res.addCapabilities(ResourceBuilder.parseCapability(res, cap));
            }
            if (metadata.containsKey("requirements")) {
                for (String req : (List)metadata.get("requirements")) {
                    res.addRequirements(ResourceBuilder.parseRequirement(res, req));
                }
            }
            resources.add(res);
        }
        return new BaseRepository(resources);
    }
}

