/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.standalone;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.impl.action.command.ManagerImpl;
import org.apache.karaf.shell.impl.console.JLineTerminal;
import org.apache.karaf.shell.impl.console.SessionFactoryImpl;
import org.apache.karaf.shell.support.ShellUtil;
import org.jline.terminal.TerminalBuilder;

public class Main {
    private String application = System.getProperty("karaf.name", "root");
    private String user = "karaf";

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        main.run(args);
    }

    public void run(String[] args) throws Exception {
        InputStream in = System.in;
        PrintStream out = System.out;
        PrintStream err = System.err;
        ThreadIOImpl threadio = new ThreadIOImpl();
        threadio.start();
        this.run(threadio, args, in, out, err);
    }

    private void run(ThreadIO threadio, String[] args, InputStream in, PrintStream out, PrintStream err) throws Exception {
        Object arg;
        StringBuilder sb = new StringBuilder();
        String classpath = null;
        boolean batch = false;
        String file = null;
        for (int i = 0; i < args.length; ++i) {
            arg = args[i];
            if (((String)arg).startsWith("--classpath=")) {
                classpath = ((String)arg).substring("--classpath=".length());
                continue;
            }
            if (((String)arg).startsWith("-c=")) {
                classpath = ((String)arg).substring("-c=".length());
                continue;
            }
            if (((String)arg).equals("--classpath") || ((String)arg).equals("-c")) {
                classpath = args[++i];
                continue;
            }
            if (((String)arg).equals("-b") || ((String)arg).equals("--batch")) {
                batch = true;
                continue;
            }
            if (((String)arg).startsWith("--file=")) {
                file = ((String)arg).substring("--file=".length());
                continue;
            }
            if (((String)arg).startsWith("-f=")) {
                file = ((String)arg).substring("-f=".length());
                continue;
            }
            if (((String)arg).equals("--file") || ((String)arg).equals("-f")) {
                file = args[++i];
                continue;
            }
            sb.append((String)arg);
            sb.append(' ');
        }
        if (file != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            arg = null;
            try {
                sb.setLength(0);
                int c = ((Reader)reader).read();
                while (c >= 0) {
                    sb.append((char)c);
                    c = ((Reader)reader).read();
                }
            }
            catch (Throwable throwable) {
                arg = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (arg != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)arg).addSuppressed(throwable);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                }
            }
        } else if (batch) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            sb.setLength(0);
            int c = ((Reader)reader).read();
            while (c >= 0) {
                sb.append((char)c);
                ((Reader)reader).read();
            }
        }
        ClassLoader cl = Main.class.getClassLoader();
        if (classpath != null) {
            List<URL> urls = Main.getFiles(new File(classpath));
            cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), cl);
        }
        SessionFactory sessionFactory = this.createSessionFactory(threadio);
        this.run(sessionFactory, sb.toString(), in, out, err, cl);
    }

    private void run(SessionFactory sessionFactory, String command, InputStream in, PrintStream out, PrintStream err, ClassLoader cl) throws Exception {
        try (org.jline.terminal.Terminal jlineTerminal = TerminalBuilder.terminal();){
            JLineTerminal terminal = new JLineTerminal(jlineTerminal);
            try (Session session = this.createSession(sessionFactory, command.length() > 0 ? null : in, out, err, terminal);){
                session.put("USER", this.user);
                session.put("APPLICATION", this.application);
                this.discoverCommands(session, cl, this.getDiscoveryResource());
                if (command.length() > 0) {
                    session.put("MULTI_SCOPE_MODE", Boolean.toString(this.isMultiScopeMode()));
                    session.put("karaf.printStackTraces", "execution");
                    try {
                        session.execute(command);
                    }
                    catch (Throwable t) {
                        ShellUtil.logException(session, t);
                    }
                } else {
                    session.run();
                }
            }
        }
    }

    protected Session createSession(SessionFactory sessionFactory, InputStream in, PrintStream out, PrintStream err, Terminal terminal) throws Exception {
        return sessionFactory.create(in, out, err, terminal, null, null);
    }

    protected SessionFactory createSessionFactory(ThreadIO threadio) {
        SessionFactoryImpl sessionFactory = new SessionFactoryImpl(threadio);
        sessionFactory.register(new ManagerImpl(sessionFactory, sessionFactory));
        return sessionFactory;
    }

    public String getDiscoveryResource() {
        return "META-INF/services/org/apache/karaf/shell/commands";
    }

    protected void discoverCommands(Session session, ClassLoader cl, String resource) throws IOException, ClassNotFoundException {
        ManagerImpl manager = new ManagerImpl(session.getRegistry(), session.getFactory().getRegistry(), true);
        Enumeration<URL> urls = cl.getResources(resource);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = r.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && line.charAt(0) != '#') {
                    Class<?> actionClass = cl.loadClass(line);
                    manager.register(actionClass);
                }
                line = r.readLine();
            }
            r.close();
        }
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean isMultiScopeMode() {
        return true;
    }

    private static List<URL> getFiles(File base) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Main.getFiles(base, urls);
        return urls;
    }

    private static void getFiles(File base, List<URL> urls) throws MalformedURLException {
        for (File f : base.listFiles()) {
            if (f.isDirectory()) {
                Main.getFiles(f, urls);
                continue;
            }
            if (!f.getName().endsWith(".jar")) continue;
            urls.add(f.toURI().toURL());
        }
    }
}

