/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.client;

import java.io.File;
import java.util.LinkedHashSet;
import org.apache.felix.utils.properties.Properties;
import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.util.config.PropertiesLoader;

public class ClientConfig {
    private static final String ROLE_DELIMITER = ",";
    private static final String GROUP_PREFIX = "_g_:";
    private String host;
    private int port;
    private String user;
    private String password;
    private int level;
    private int retryAttempts;
    private int retryDelay;
    private long idleTimeout;
    private boolean batch;
    private String file = null;
    private String keyFile = null;
    private String command;
    private boolean interactiveMode = false;
    private boolean inputPassword = false;
    private TypedProperties configuration;

    public ClientConfig(String[] args) throws Exception {
        Properties usersCfg;
        File karafEtc = new File(System.getProperty("karaf.etc"));
        PropertiesLoader.loadSystemProperties(new File(karafEtc, "system.properties"));
        Properties configProps = PropertiesLoader.loadConfigProperties(new File(karafEtc, "config.properties"));
        this.configuration = ClientConfig.loadProps(new File(karafEtc, "org.apache.karaf.shell.cfg"), configProps);
        this.host = this.getString("sshHost", "localhost");
        if (this.host.contains("0.0.0.0")) {
            this.host = "localhost";
        }
        this.port = this.getInt("sshPort", 8101);
        this.level = this.getInt("logLevel", 0);
        this.retryAttempts = 0;
        this.retryDelay = 2;
        this.idleTimeout = this.getLong("sshIdleTimeout", 1800000L);
        this.batch = false;
        this.file = null;
        this.user = null;
        this.password = null;
        StringBuilder commandBuilder = new StringBuilder();
        boolean endOfOptionsMarkerReached = false;
        for (int i = 0; i < args.length; ++i) {
            if (!endOfOptionsMarkerReached && args[i].charAt(0) == '-') {
                if (args[i].equals("-a")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the port");
                        System.exit(1);
                        continue;
                    }
                    this.port = Integer.parseInt(args[i]);
                    continue;
                }
                if (args[i].equals("-h")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the host");
                        System.exit(1);
                        continue;
                    }
                    this.host = args[i];
                    continue;
                }
                if (args[i].equals("-u")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the user");
                        System.exit(1);
                        continue;
                    }
                    this.user = args[i];
                    this.interactiveMode = true;
                    this.password = null;
                    continue;
                }
                if (args[i].equals("-v")) {
                    ++this.level;
                    continue;
                }
                if (args[i].equals("-l")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the log level");
                        System.exit(1);
                        continue;
                    }
                    int levelValue = Integer.parseInt(args[i]);
                    if (levelValue < 0 || levelValue > 4) {
                        System.err.println("log level can only be 0, 1, 2, 3, or 4");
                        System.exit(1);
                        continue;
                    }
                    this.level = levelValue;
                    continue;
                }
                if (args[i].equals("-r")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the attempts");
                        System.exit(1);
                        continue;
                    }
                    this.retryAttempts = Integer.parseInt(args[i]);
                    continue;
                }
                if (args[i].equals("-p")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the password");
                        System.exit(1);
                        continue;
                    }
                    this.password = args[i];
                    this.interactiveMode = false;
                    this.inputPassword = true;
                    continue;
                }
                if (args[i].equals("-d")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the delay in seconds");
                        System.exit(1);
                        continue;
                    }
                    this.retryDelay = Integer.parseInt(args[i]);
                    continue;
                }
                if (args[i].equals("-b")) {
                    this.batch = true;
                    continue;
                }
                if (args[i].equals("-f")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the commands file");
                        System.exit(1);
                        continue;
                    }
                    this.file = args[i];
                    continue;
                }
                if (args[i].equals("-k")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the key file");
                        System.exit(1);
                        continue;
                    }
                    this.keyFile = args[i];
                    continue;
                }
                if (args[i].equals("-t")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the idle timeout");
                        System.exit(1);
                        continue;
                    }
                    this.idleTimeout = Long.parseLong(args[i]);
                    continue;
                }
                if (args[i].equals("--help")) {
                    ClientConfig.showHelp();
                    continue;
                }
                if (args[i].equals("--")) {
                    endOfOptionsMarkerReached = true;
                    continue;
                }
                System.err.println("Unknown option: " + args[i]);
                System.err.println("Run with --help for usage");
                System.exit(1);
                continue;
            }
            commandBuilder.append(args[i]);
            commandBuilder.append(' ');
        }
        this.command = commandBuilder.toString();
        File userPropertiesFile = new File(karafEtc, "users.properties");
        if (userPropertiesFile.exists() && !(usersCfg = PropertiesLoader.loadPropertiesFile(userPropertiesFile.toURI().toURL(), false)).isEmpty()) {
            LinkedHashSet<String> users = new LinkedHashSet<String>();
            for (String user : usersCfg.keySet()) {
                if (user.startsWith(GROUP_PREFIX)) continue;
                users.add(user);
            }
            if (this.user == null && users.iterator().hasNext()) {
                this.user = (String)users.iterator().next();
            }
            if (this.interactiveMode && !this.inputPassword) {
                this.password = null;
            } else if (!this.inputPassword) {
                this.password = (String)usersCfg.get(this.user);
                if (this.password != null && this.password.contains(ROLE_DELIMITER)) {
                    this.password = this.password.substring(0, this.password.indexOf(ROLE_DELIMITER));
                }
            }
        }
    }

    private static void showHelp() {
        System.out.println("Apache Karaf client");
        System.out.println("  -a [port]     specify the port to connect to");
        System.out.println("  -h [host]     specify the host to connect to");
        System.out.println("  -u [user]     specify the user name");
        System.out.println("  -p [password] specify the password (optional, if not provided, the password is prompted)");
        System.out.println("  --help        shows this help message");
        System.out.println("  -v            raise verbosity");
        System.out.println("  -l            set client logging level. Set to 0 for ERROR logging and up to 4 for TRACE");
        System.out.println("  -r [attempts] retry connection establishment (up to attempts times)");
        System.out.println("  -d [delay]    intra-retry delay (defaults to 2 seconds)");
        System.out.println("  -b            batch mode, specify multiple commands via standard input");
        System.out.println("  -f [file]     read commands from the specified file");
        System.out.println("  -k [keyFile]  specify the private keyFile location when using key login, need have BouncyCastle registered as security provider using this flag");
        System.out.println("  -t [timeout]  define the client idle timeout");
        System.out.println("  [commands] [--]   commands to run");
        System.out.println("If no commands are specified, the client will be put in an interactive mode");
        System.exit(0);
    }

    private static TypedProperties loadProps(File file, Properties context) {
        TypedProperties props = new TypedProperties((name, key, value) -> context.getProperty(value));
        try {
            props.load(file);
        }
        catch (Exception e) {
            System.err.println("Warning: could not load properties from: " + file + ": " + e);
        }
        return props;
    }

    protected int getInt(String key, int def) {
        if (this.configuration != null) {
            Object val = this.configuration.get(key);
            if (val instanceof Number) {
                return ((Number)val).intValue();
            }
            if (val != null) {
                return Integer.parseInt(val.toString());
            }
        }
        return def;
    }

    protected long getLong(String key, long def) {
        if (this.configuration != null) {
            Object val = this.configuration.get(key);
            if (val instanceof Number) {
                return ((Number)val).longValue();
            }
            if (val != null) {
                return Long.parseLong(val.toString());
            }
        }
        return def;
    }

    protected String getString(String key, String def) {
        Object val;
        if (this.configuration != null && (val = this.configuration.get(key)) != null) {
            return val.toString();
        }
        return def;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getLevel() {
        return this.level;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public String getFile() {
        return this.file;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }
}

