/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime.dto;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.registry.ErrorPageRegistry;
import org.apache.felix.http.base.internal.runtime.AbstractInfo;
import org.apache.felix.http.base.internal.runtime.FilterInfo;
import org.apache.felix.http.base.internal.runtime.ListenerInfo;
import org.apache.felix.http.base.internal.runtime.ResourceInfo;
import org.apache.felix.http.base.internal.runtime.ServletContextHelperInfo;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.runtime.dto.ErrorPageDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.FilterDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.ListenerDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.ResourceDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.ServletContextDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.ServletDTOBuilder;
import org.osgi.service.http.runtime.dto.BaseServletDTO;
import org.osgi.service.http.runtime.dto.FailedErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;
import org.osgi.service.http.runtime.dto.FailedListenerDTO;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;
import org.osgi.service.http.runtime.dto.FailedServletContextDTO;
import org.osgi.service.http.runtime.dto.FailedServletDTO;

public final class FailedDTOHolder {
    public final List<FailedFilterDTO> failedFilterDTOs = new ArrayList<FailedFilterDTO>();
    public final List<FailedListenerDTO> failedListenerDTOs = new ArrayList<FailedListenerDTO>();
    public final List<FailedServletDTO> failedServletDTOs = new ArrayList<FailedServletDTO>();
    public final List<FailedResourceDTO> failedResourceDTOs = new ArrayList<FailedResourceDTO>();
    public final List<FailedErrorPageDTO> failedErrorPageDTOs = new ArrayList<FailedErrorPageDTO>();
    public final List<FailedServletContextDTO> failedServletContextDTO = new ArrayList<FailedServletContextDTO>();

    public void add(AbstractInfo<?> info, long contextId, int failureCode) {
        if (info instanceof ServletContextHelperInfo) {
            FailedServletContextDTO dto = (FailedServletContextDTO)ServletContextDTOBuilder.build((ServletContextHelperInfo)info, null, failureCode);
            this.failedServletContextDTO.add(dto);
        } else if (info instanceof ServletInfo) {
            BaseServletDTO dto;
            boolean isError = false;
            if (((ServletInfo)info).getErrorPage() != null) {
                isError = true;
                dto = (FailedErrorPageDTO)ErrorPageDTOBuilder.build((ServletInfo)info, true);
                dto.failureReason = failureCode;
                ErrorPageRegistry.ErrorRegistration reg = ErrorPageRegistry.getErrorRegistration((ServletInfo)info);
                dto.errorCodes = reg.errorCodes;
                dto.exceptions = reg.exceptions;
                dto.servletContextId = contextId;
                this.failedErrorPageDTOs.add((FailedErrorPageDTO)dto);
            }
            if (((ServletInfo)info).getPatterns() != null || !isError) {
                dto = (FailedServletDTO)ServletDTOBuilder.build((ServletInfo)info, failureCode);
                if (((ServletInfo)info).getPatterns() != null) {
                    ((FailedServletDTO)dto).patterns = ((ServletInfo)info).getPatterns();
                }
                ((FailedServletDTO)dto).servletContextId = contextId;
                this.failedServletDTOs.add((FailedServletDTO)dto);
            }
        } else if (info instanceof FilterInfo) {
            FailedFilterDTO dto = (FailedFilterDTO)FilterDTOBuilder.build((FilterInfo)info, failureCode);
            dto.failureReason = failureCode;
            dto.servletContextId = contextId;
            this.failedFilterDTOs.add(dto);
        } else if (info instanceof ResourceInfo) {
            FailedResourceDTO dto = (FailedResourceDTO)ResourceDTOBuilder.build((ResourceInfo)info, true);
            dto.failureReason = failureCode;
            dto.servletContextId = contextId;
            this.failedResourceDTOs.add(dto);
        } else if (info instanceof ListenerInfo) {
            FailedListenerDTO dto = (FailedListenerDTO)ListenerDTOBuilder.build((ListenerInfo)info, failureCode);
            dto.servletContextId = contextId;
            this.failedListenerDTOs.add(dto);
        } else {
            SystemLogger.error("Unsupported info type: " + info.getClass(), null);
        }
    }
}

